/*
 * Decompiled with CFR 0.152.
 */
package net.skripthub.docstool.documentation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.skripthub.docstool.documentation.FileType;
import net.skripthub.docstool.modals.AddonData;
import net.skripthub.docstool.modals.SyntaxData;
import net.skripthub.skripthubdocstool.Metadata;
import net.skripthub.skripthubdocstool.TypeCastException;
import net.skripthub.skripthubdocstool.jvm.internal.Intrinsics;
import net.skripthub.skripthubdocstool.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/skripthub/docstool/documentation/JsonFile;", "Lnet/skripthub/docstool/documentation/FileType;", "raw", "", "(Z)V", "gson", "Lcom/google/gson/Gson;", "addSection", "", "json", "Lcom/google/gson/JsonObject;", "property", "", "list", "", "Lnet/skripthub/docstool/modals/SyntaxData;", "getJsonSyntax", "info", "write", "writer", "Ljava/io/BufferedWriter;", "addon", "Lnet/skripthub/docstool/modals/AddonData;", "skripthubdocstool"})
public final class JsonFile
extends FileType {
    private final Gson gson;

    @Override
    public void write(@NotNull BufferedWriter writer, @NotNull AddonData addon) throws IOException {
        Intrinsics.checkParameterIsNotNull(writer, "writer");
        Intrinsics.checkParameterIsNotNull(addon, "addon");
        JsonObject json = new JsonObject();
        this.addSection(json, "events", addon.getEvents());
        this.addSection(json, "conditions", addon.getConditions());
        this.addSection(json, "effects", addon.getEffects());
        this.addSection(json, "expressions", addon.getExpressions());
        this.addSection(json, "types", addon.getTypes());
        this.addSection(json, "functions", addon.getFunctions());
        this.gson.toJson((JsonElement)json, (Appendable)writer);
    }

    public final void addSection(@NotNull JsonObject json, @NotNull String property, @NotNull List<SyntaxData> list) {
        Intrinsics.checkParameterIsNotNull(json, "json");
        Intrinsics.checkParameterIsNotNull(property, "property");
        Intrinsics.checkParameterIsNotNull(list, "list");
        JsonArray array = new JsonArray();
        for (SyntaxData syntax : list) {
            JsonObject jsonSyntax = this.getJsonSyntax(syntax);
            if (!jsonSyntax.has("patterns")) continue;
            array.add((JsonElement)this.getJsonSyntax(syntax));
        }
        if (array.size() > 0) {
            json.add(property, (JsonElement)array);
        }
    }

    @NotNull
    public final JsonObject getJsonSyntax(@NotNull SyntaxData info) {
        Intrinsics.checkParameterIsNotNull(info, "info");
        JsonObject syntax = new JsonObject();
        for (Map.Entry<String, Object> entry : info.toMap().entrySet()) {
            String string;
            String string2 = string = entry.getKey();
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            String property = StringsKt.replace$default(string3, '_', ' ', false, 4, null);
            if (entry.getValue() instanceof String) {
                Object object = entry.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                syntax.addProperty(property, (String)object);
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                Object object = entry.getValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                syntax.addProperty(property, (Boolean)object);
                continue;
            }
            JsonArray json = new JsonArray();
            Object object = entry.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            }
            for (String str : (String[])object) {
                json.add((JsonElement)new JsonPrimitive(str));
            }
            syntax.add(property, (JsonElement)json);
        }
        return syntax;
    }

    public JsonFile(boolean raw) {
        super("json");
        GsonBuilder gson = new GsonBuilder().disableHtmlEscaping();
        if (!raw) {
            gson.enableComplexMapKeySerialization().setPrettyPrinting();
        }
        Gson gson2 = gson.create();
        Intrinsics.checkExpressionValueIsNotNull(gson2, "gson.create()");
        this.gson = gson2;
    }
}

