/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends TwoArgFunction {
    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable table = new LuaTable();
        table.set("concat", (LuaValue)new concat());
        table.set("insert", (LuaValue)new insert());
        table.set("pack", (LuaValue)new pack());
        table.set("remove", (LuaValue)new remove());
        table.set("sort", (LuaValue)new sort());
        table.set("unpack", (LuaValue)new unpack());
        env.set("table", (LuaValue)table);
        env.get("package").get("loaded").set("table", (LuaValue)table);
        return NIL;
    }

    static class TableLibFunction
    extends LibFunction {
        TableLibFunction() {
        }

        @Override
        public LuaValue call() {
            return TableLibFunction.argerror(1, "table expected, got no value");
        }
    }

    static class concat
    extends TableLibFunction {
        concat() {
        }

        @Override
        public LuaValue call(LuaValue list) {
            return list.checktable().concat(EMPTYSTRING, 1, list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep) {
            return list.checktable().concat(sep.checkstring(), 1, list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep, LuaValue i) {
            return list.checktable().concat(sep.checkstring(), i.checkint(), list.length());
        }

        @Override
        public LuaValue call(LuaValue list, LuaValue sep, LuaValue i, LuaValue j) {
            return list.checktable().concat(sep.checkstring(), i.checkint(), j.checkint());
        }
    }

    static class insert
    extends VarArgFunction {
        insert() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            switch (args.narg()) {
                case 0: 
                case 1: {
                    return insert.argerror(2, "value expected");
                }
                case 2: {
                    LuaTable table = args.arg1().checktable();
                    table.insert(table.length() + 1, args.arg(2));
                    return NONE;
                }
            }
            args.arg1().checktable().insert(args.checkint(2), args.arg(3));
            return NONE;
        }
    }

    static class pack
    extends VarArgFunction {
        pack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t = pack.tableOf(args, 1);
            t.set("n", args.narg());
            return t;
        }
    }

    static class remove
    extends VarArgFunction {
        remove() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return args.arg1().checktable().remove(args.optint(2, 0));
        }
    }

    static class sort
    extends VarArgFunction {
        sort() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            args.arg1().checktable().sort(args.arg(2).isnil() ? NIL : args.arg(2).checkfunction());
            return NONE;
        }
    }

    static class unpack
    extends VarArgFunction {
        unpack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t = args.checktable(1);
            switch (args.narg()) {
                case 1: {
                    return t.unpack();
                }
                case 2: {
                    return t.unpack(args.checkint(2));
                }
            }
            return t.unpack(args.checkint(2), args.checkint(3));
        }
    }
}

