/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class PackageLib
extends TwoArgFunction {
    public static String DEFAULT_LUA_PATH;
    private static final LuaString _LOADED;
    private static final LuaString _LOADLIB;
    private static final LuaString _PRELOAD;
    private static final LuaString _PATH;
    private static final LuaString _SEARCHPATH;
    private static final LuaString _SEARCHERS;
    Globals globals;
    LuaTable package_;
    public preload_searcher preload_searcher;
    public lua_searcher lua_searcher;
    public java_searcher java_searcher;
    private static final LuaString _SENTINEL;
    private static final String FILE_SEP;

    static {
        try {
            DEFAULT_LUA_PATH = System.getProperty("luaj.package.path");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (DEFAULT_LUA_PATH == null) {
            DEFAULT_LUA_PATH = "?.lua";
        }
        _LOADED = PackageLib.valueOf("loaded");
        _LOADLIB = PackageLib.valueOf("loadlib");
        _PRELOAD = PackageLib.valueOf("preload");
        _PATH = PackageLib.valueOf("path");
        _SEARCHPATH = PackageLib.valueOf("searchpath");
        _SEARCHERS = PackageLib.valueOf("searchers");
        _SENTINEL = PackageLib.valueOf("\u0001");
        FILE_SEP = System.getProperty("file.separator");
    }

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        this.globals.set("require", (LuaValue)new require());
        this.package_ = new LuaTable();
        this.package_.set(_LOADED, (LuaValue)new LuaTable());
        this.package_.set(_PRELOAD, (LuaValue)new LuaTable());
        this.package_.set(_PATH, (LuaValue)LuaValue.valueOf(DEFAULT_LUA_PATH));
        this.package_.set(_LOADLIB, (LuaValue)new loadlib());
        this.package_.set(_SEARCHPATH, (LuaValue)new searchpath());
        LuaTable searchers = new LuaTable();
        this.preload_searcher = new preload_searcher();
        searchers.set(1, (LuaValue)this.preload_searcher);
        this.lua_searcher = new lua_searcher();
        searchers.set(2, (LuaValue)this.lua_searcher);
        this.java_searcher = new java_searcher();
        searchers.set(3, (LuaValue)this.java_searcher);
        this.package_.set(_SEARCHERS, (LuaValue)searchers);
        this.package_.get(_LOADED).set("package", (LuaValue)this.package_);
        env.set("package", (LuaValue)this.package_);
        this.globals.package_ = this;
        return env;
    }

    public void setIsLoaded(String name, LuaTable value) {
        this.package_.get(_LOADED).set(name, (LuaValue)value);
    }

    public void setLuaPath(String newLuaPath) {
        this.package_.set(_PATH, (LuaValue)LuaValue.valueOf(newLuaPath));
    }

    @Override
    public String tojstring() {
        return "package";
    }

    public static final String toClassname(String filename) {
        int n;
        int j = n = filename.length();
        if (filename.endsWith(".lua")) {
            j -= 4;
        }
        int k = 0;
        while (k < j) {
            int c = filename.charAt(k);
            if (!PackageLib.isClassnamePart((char)c) || c == 47 || c == 92) {
                StringBuffer sb = new StringBuffer(j);
                int i = 0;
                while (i < j) {
                    c = filename.charAt(i);
                    sb.append((char)(PackageLib.isClassnamePart((char)c) ? c : (c == 47 || c == 92 ? 46 : 95)));
                    ++i;
                }
                return sb.toString();
            }
            ++k;
        }
        return n == j ? filename : filename.substring(0, j);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public class java_searcher
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs args) {
            String name = args.checkjstring(1);
            String classname = PackageLib.toClassname(name);
            Class<?> c = null;
            LuaValue v = null;
            try {
                c = Class.forName(classname);
                v = (LuaValue)c.newInstance();
                if (v.isfunction()) {
                    ((LuaFunction)v).initupvalue1(PackageLib.this.globals);
                }
                return org.luaj.vm2.lib.PackageLib$java_searcher.varargsOf(v, (Varargs)PackageLib.this.globals);
            }
            catch (ClassNotFoundException cnfe) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tno class '" + classname + "'");
            }
            catch (Exception e) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tjava load failed on '" + classname + "', " + e);
            }
        }
    }

    public static class loadlib
    extends VarArgFunction {
        public Varargs loadlib(Varargs args) {
            args.checkstring(1);
            return loadlib.varargsOf(NIL, loadlib.valueOf("dynamic libraries not enabled"), loadlib.valueOf("absent"));
        }
    }

    public class lua_searcher
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs args) {
            LuaString name = args.checkstring(1);
            Object is = null;
            LuaValue path = PackageLib.this.package_.get(_PATH);
            if (!path.isstring()) {
                return org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("package.path is not a string");
            }
            Varargs v = PackageLib.this.package_.get(_SEARCHPATH).invoke(org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(name, (Varargs)path));
            if (!v.isstring(1)) {
                return v.arg(2).tostring();
            }
            LuaString filename = v.arg1().strvalue();
            if ((v = PackageLib.this.globals.loadfile(filename.tojstring())).arg1().isfunction()) {
                return LuaValue.varargsOf(v.arg1(), (Varargs)filename);
            }
            return org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(NIL, (Varargs)org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("'" + filename + "': " + v.arg(2).tojstring()));
        }
    }

    public class preload_searcher
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs args) {
            LuaString name = args.checkstring(1);
            LuaValue val = PackageLib.this.package_.get(_PRELOAD).get(name);
            return val.isnil() ? org.luaj.vm2.lib.PackageLib$preload_searcher.valueOf("\n\tno field package.preload['" + name + "']") : val;
        }
    }

    public class require
    extends OneArgFunction {
        @Override
        public LuaValue call(LuaValue arg) {
            LuaString name = arg.checkstring();
            LuaValue loaded = PackageLib.this.package_.get(_LOADED);
            LuaValue result = loaded.get(name);
            if (result.toboolean()) {
                if (result == _SENTINEL) {
                    require.error("loop or previous error loading module '" + name + "'");
                }
                return result;
            }
            LuaTable tbl = PackageLib.this.package_.get(_SEARCHERS).checktable();
            StringBuffer sb = new StringBuffer();
            Varargs loader = null;
            int i = 1;
            while (true) {
                LuaValue searcher;
                if ((searcher = tbl.get(i)).isnil()) {
                    require.error("module '" + name + "' not found: " + name + sb);
                }
                if ((loader = searcher.invoke(name)).isfunction(1)) break;
                if (loader.isstring(1)) {
                    sb.append(loader.tojstring(1));
                }
                ++i;
            }
            loaded.set(name, (LuaValue)_SENTINEL);
            result = loader.arg1().call(name, loader.arg(2));
            if (!result.isnil()) {
                loaded.set(name, result);
            } else {
                result = loaded.get(name);
                if (result == _SENTINEL) {
                    result = LuaValue.TRUE;
                    loaded.set(name, result);
                }
            }
            return result;
        }
    }

    public class searchpath
    extends VarArgFunction {
        @Override
        public Varargs invoke(Varargs args) {
            String name = args.checkjstring(1);
            String path = args.checkjstring(2);
            String sep = args.optjstring(3, ".");
            String rep2 = args.optjstring(4, FILE_SEP);
            int e = -1;
            int n = path.length();
            StringBuffer sb = null;
            name = name.replace(sep.charAt(0), rep2.charAt(0));
            while (e < n) {
                InputStream is;
                int b = e + 1;
                if ((e = path.indexOf(59, b)) < 0) {
                    e = path.length();
                }
                String template = path.substring(b, e);
                int q = template.indexOf(63);
                String filename = template;
                if (q >= 0) {
                    filename = String.valueOf(template.substring(0, q)) + name + template.substring(q + 1);
                }
                if ((is = PackageLib.this.globals.finder.findResource(filename)) != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return searchpath.valueOf(filename);
                }
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append("\n\t" + filename);
            }
            return searchpath.varargsOf(NIL, (Varargs)searchpath.valueOf(sb.toString()));
        }
    }
}

