/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public abstract class LibFunction
extends LuaFunction {
    protected int opcode;
    protected String name;

    protected LibFunction() {
    }

    @Override
    public String tojstring() {
        return this.name != null ? this.name : super.tojstring();
    }

    protected void bind(LuaValue env, Class factory, String[] names) {
        this.bind(env, factory, names, 0);
    }

    protected void bind(LuaValue env, Class factory, String[] names, int firstopcode) {
        try {
            int i = 0;
            int n = names.length;
            while (i < n) {
                LibFunction f = (LibFunction)factory.newInstance();
                f.opcode = firstopcode + i;
                f.name = names[i];
                env.set(f.name, (LuaValue)f);
                ++i;
            }
        }
        catch (Exception e) {
            throw new LuaError("bind failed: " + e);
        }
    }

    protected static LuaValue[] newupe() {
        return new LuaValue[1];
    }

    protected static LuaValue[] newupn() {
        return new LuaValue[]{NIL};
    }

    protected static LuaValue[] newupl(LuaValue v) {
        return new LuaValue[]{v};
    }

    @Override
    public LuaValue call() {
        return LibFunction.argerror(1, "value");
    }

    @Override
    public LuaValue call(LuaValue a) {
        return this.call();
    }

    @Override
    public LuaValue call(LuaValue a, LuaValue b) {
        return this.call(a);
    }

    @Override
    public LuaValue call(LuaValue a, LuaValue b, LuaValue c) {
        return this.call(a, b);
    }

    public LuaValue call(LuaValue a, LuaValue b, LuaValue c, LuaValue d) {
        return this.call(a, b, c);
    }

    @Override
    public Varargs invoke(Varargs args) {
        switch (args.narg()) {
            case 0: {
                return this.call();
            }
            case 1: {
                return this.call(args.arg1());
            }
            case 2: {
                return this.call(args.arg1(), args.arg(2));
            }
            case 3: {
                return this.call(args.arg1(), args.arg(2), args.arg(3));
            }
        }
        return this.call(args.arg1(), args.arg(2), args.arg(3), args.arg(4));
    }
}

