/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.compiler.Constants;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LexState;
import org.luaj.vm2.compiler.LuaC;

public class FuncState
extends Constants {
    Prototype f;
    Hashtable h;
    FuncState prev;
    LexState ls;
    LuaC.CompileState L;
    BlockCnt bl;
    int pc;
    int lasttarget;
    IntPtr jpc;
    int nk;
    int np;
    int firstlocal;
    short nlocvars;
    short nactvar;
    short nups;
    short freereg;

    FuncState() {
    }

    InstructionPtr getcodePtr(LexState.expdesc e) {
        return new InstructionPtr(this.f.code, e.u.info);
    }

    int getcode(LexState.expdesc e) {
        return this.f.code[e.u.info];
    }

    int codeAsBx(int o, int A, int sBx) {
        return this.codeABx(o, A, sBx + 131071);
    }

    void setmultret(LexState.expdesc e) {
        this.setreturns(e, -1);
    }

    void checkrepeated(LexState.Labeldesc[] ll, int ll_n, LuaString label) {
        int i = this.bl.firstlabel;
        while (i < ll_n) {
            if (label.eq_b(ll[i].name)) {
                String msg = this.ls.L.pushfstring("label '" + label + " already defined on line " + ll[i].line);
                this.ls.semerror(msg);
            }
            ++i;
        }
    }

    void checklimit(int v, int l, String msg) {
        if (v > l) {
            this.errorlimit(l, msg);
        }
    }

    void errorlimit(int limit, String what) {
        String msg = this.f.linedefined == 0 ? this.L.pushfstring("main function has more than " + limit + " " + what) : this.L.pushfstring("function at line " + this.f.linedefined + " has more than " + limit + " " + what);
        this.ls.lexerror(msg, 0);
    }

    LocVars getlocvar(int i) {
        short idx = this.ls.dyd.actvar[this.firstlocal + i].idx;
        FuncState._assert(idx < this.nlocvars);
        return this.f.locvars[idx];
    }

    void removevars(int tolevel) {
        this.ls.dyd.n_actvar -= this.nactvar - tolevel;
        while (this.nactvar > tolevel) {
            this.nactvar = (short)(this.nactvar - 1);
            this.getlocvar((int)((short)(this.nactvar - 1))).endpc = this.pc;
        }
    }

    int searchupvalue(LuaString name) {
        Upvaldesc[] up = this.f.upvalues;
        int i = 0;
        while (i < this.nups) {
            if (up[i].name.eq_b(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int newupvalue(LuaString name, LexState.expdesc v) {
        this.checklimit(this.nups + 1, 255, "upvalues");
        if (this.f.upvalues == null || this.nups + 1 > this.f.upvalues.length) {
            this.f.upvalues = FuncState.realloc(this.f.upvalues, this.nups > 0 ? this.nups * 2 : 1);
        }
        this.f.upvalues[this.nups] = new Upvaldesc(name, v.k == 7, v.u.info);
        short s = this.nups;
        this.nups = (short)(s + 1);
        return s;
    }

    int searchvar(LuaString n) {
        int i = this.nactvar - 1;
        while (i >= 0) {
            if (n.eq_b(this.getlocvar((int)i).varname)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    void markupval(int level) {
        BlockCnt bl = this.bl;
        while (bl.nactvar > level) {
            bl = bl.previous;
        }
        bl.upval = true;
    }

    static int singlevaraux(FuncState fs, LuaString n, LexState.expdesc var, int base) {
        if (fs == null) {
            return 0;
        }
        int v = fs.searchvar(n);
        if (v >= 0) {
            var.init(7, v);
            if (base == 0) {
                fs.markupval(v);
            }
            return 7;
        }
        int idx = fs.searchupvalue(n);
        if (idx < 0) {
            if (FuncState.singlevaraux(fs.prev, n, var, 0) == 0) {
                return 0;
            }
            idx = fs.newupvalue(n, var);
        }
        var.init(8, idx);
        return 8;
    }

    void movegotosout(BlockCnt bl) {
        int i = bl.firstgoto;
        LexState.Labeldesc[] gl = this.ls.dyd.gt;
        while (i < this.ls.dyd.n_gt) {
            LexState.Labeldesc gt = gl[i];
            if (gt.nactvar > bl.nactvar) {
                if (bl.upval) {
                    this.patchclose(gt.pc, bl.nactvar);
                }
                gt.nactvar = bl.nactvar;
            }
            if (this.ls.findlabel(i)) continue;
            ++i;
        }
    }

    void enterblock(BlockCnt bl, boolean isloop) {
        bl.isloop = isloop;
        bl.nactvar = this.nactvar;
        bl.firstlabel = (short)this.ls.dyd.n_label;
        bl.firstgoto = (short)this.ls.dyd.n_gt;
        bl.upval = false;
        bl.previous = this.bl;
        this.bl = bl;
        FuncState._assert(this.freereg == this.nactvar);
    }

    void leaveblock() {
        BlockCnt bl = this.bl;
        if (bl.previous != null && bl.upval) {
            int j = this.jump();
            this.patchclose(j, bl.nactvar);
            this.patchtohere(j);
        }
        if (bl.isloop) {
            this.ls.breaklabel();
        }
        this.bl = bl.previous;
        this.removevars(bl.nactvar);
        FuncState._assert(bl.nactvar == this.nactvar);
        this.freereg = this.nactvar;
        this.ls.dyd.n_label = bl.firstlabel;
        if (bl.previous != null) {
            this.movegotosout(bl);
        } else if (bl.firstgoto < this.ls.dyd.n_gt) {
            this.ls.undefgoto(this.ls.dyd.gt[bl.firstgoto]);
        }
    }

    void closelistfield(LexState.ConsControl cc) {
        if (cc.v.k == 0) {
            return;
        }
        this.exp2nextreg(cc.v);
        cc.v.k = 0;
        if (cc.tostore == 50) {
            this.setlist(cc.t.u.info, cc.na, cc.tostore);
            cc.tostore = 0;
        }
    }

    boolean hasmultret(int k) {
        return k == 12 || k == 13;
    }

    void lastlistfield(LexState.ConsControl cc) {
        if (cc.tostore == 0) {
            return;
        }
        if (this.hasmultret(cc.v.k)) {
            this.setmultret(cc.v);
            this.setlist(cc.t.u.info, cc.na, -1);
            --cc.na;
        } else {
            if (cc.v.k != 0) {
                this.exp2nextreg(cc.v);
            }
            this.setlist(cc.t.u.info, cc.na, cc.tostore);
        }
    }

    void nil(int from, int n) {
        int previous_code;
        int l = from + n - 1;
        if (this.pc > this.lasttarget && this.pc > 0 && FuncState.GET_OPCODE(previous_code = this.f.code[this.pc - 1]) == 4) {
            int pfrom = FuncState.GETARG_A(previous_code);
            int pl = pfrom + FuncState.GETARG_B(previous_code);
            if (pfrom <= from && from <= pl + 1 || from <= pfrom && pfrom <= l + 1) {
                if (pfrom < from) {
                    from = pfrom;
                }
                if (pl > l) {
                    l = pl;
                }
                InstructionPtr previous = new InstructionPtr(this.f.code, this.pc - 1);
                FuncState.SETARG_A(previous, from);
                FuncState.SETARG_B(previous, l - from);
                return;
            }
        }
        this.codeABC(4, from, n - 1, 0);
    }

    int jump() {
        int jpc = this.jpc.i;
        this.jpc.i = -1;
        IntPtr j = new IntPtr(this.codeAsBx(23, 0, -1));
        this.concat(j, jpc);
        return j.i;
    }

    void ret(int first, int nret) {
        this.codeABC(31, first, nret + 1, 0);
    }

    int condjump(int op, int A, int B, int C) {
        this.codeABC(op, A, B, C);
        return this.jump();
    }

    void fixjump(int pc, int dest) {
        InstructionPtr jmp = new InstructionPtr(this.f.code, pc);
        int offset = dest - (pc + 1);
        FuncState._assert(dest != -1);
        if (Math.abs(offset) > 131071) {
            this.ls.syntaxerror("control structure too long");
        }
        FuncState.SETARG_sBx(jmp, offset);
    }

    int getlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    int getjump(int pc) {
        int offset = FuncState.GETARG_sBx(this.f.code[pc]);
        if (offset == -1) {
            return -1;
        }
        return pc + 1 + offset;
    }

    InstructionPtr getjumpcontrol(int pc) {
        InstructionPtr pi = new InstructionPtr(this.f.code, pc);
        if (pc >= 1 && FuncState.testTMode(FuncState.GET_OPCODE(pi.code[pi.idx - 1]))) {
            return new InstructionPtr(pi.code, pi.idx - 1);
        }
        return pi;
    }

    boolean need_value(int list) {
        while (list != -1) {
            int i = this.getjumpcontrol(list).get();
            if (FuncState.GET_OPCODE(i) != 28) {
                return true;
            }
            list = this.getjump(list);
        }
        return false;
    }

    boolean patchtestreg(int node, int reg) {
        InstructionPtr i = this.getjumpcontrol(node);
        if (FuncState.GET_OPCODE(i.get()) != 28) {
            return false;
        }
        if (reg != 255 && reg != FuncState.GETARG_B(i.get())) {
            FuncState.SETARG_A(i, reg);
        } else {
            i.set(FuncState.CREATE_ABC(27, FuncState.GETARG_B(i.get()), 0, Lua.GETARG_C(i.get())));
        }
        return true;
    }

    void removevalues(int list) {
        while (list != -1) {
            this.patchtestreg(list, 255);
            list = this.getjump(list);
        }
    }

    void patchlistaux(int list, int vtarget, int reg, int dtarget) {
        while (list != -1) {
            int next2 = this.getjump(list);
            if (this.patchtestreg(list, reg)) {
                this.fixjump(list, vtarget);
            } else {
                this.fixjump(list, dtarget);
            }
            list = next2;
        }
    }

    void dischargejpc() {
        this.patchlistaux(this.jpc.i, this.pc, 255, this.pc);
        this.jpc.i = -1;
    }

    void patchlist(int list, int target) {
        if (target == this.pc) {
            this.patchtohere(list);
        } else {
            FuncState._assert(target < this.pc);
            this.patchlistaux(list, target, 255, target);
        }
    }

    void patchclose(int list, int level) {
        ++level;
        while (list != -1) {
            int next2 = this.getjump(list);
            FuncState._assert(FuncState.GET_OPCODE(this.f.code[list]) == 23 && (FuncState.GETARG_A(this.f.code[list]) == 0 || FuncState.GETARG_A(this.f.code[list]) >= level));
            FuncState.SETARG_A(this.f.code, list, level);
            list = next2;
        }
    }

    void patchtohere(int list) {
        this.getlabel();
        this.concat(this.jpc, list);
    }

    void concat(IntPtr l1, int l2) {
        if (l2 == -1) {
            return;
        }
        if (l1.i == -1) {
            l1.i = l2;
        } else {
            int next2;
            int list = l1.i;
            while ((next2 = this.getjump(list)) != -1) {
                list = next2;
            }
            this.fixjump(list, l2);
        }
    }

    void checkstack(int n) {
        int newstack = this.freereg + n;
        if (newstack > this.f.maxstacksize) {
            if (newstack >= 250) {
                this.ls.syntaxerror("function or expression too complex");
            }
            this.f.maxstacksize = newstack;
        }
    }

    void reserveregs(int n) {
        this.checkstack(n);
        this.freereg = (short)(this.freereg + n);
    }

    void freereg(int reg) {
        if (!FuncState.ISK(reg) && reg >= this.nactvar) {
            this.freereg = (short)(this.freereg - 1);
            FuncState._assert(reg == this.freereg);
        }
    }

    void freeexp(LexState.expdesc e) {
        if (e.k == 6) {
            this.freereg(e.u.info);
        }
    }

    int addk(LuaValue v) {
        if (this.h == null) {
            this.h = new Hashtable();
        } else if (this.h.containsKey(v)) {
            return (Integer)this.h.get(v);
        }
        int idx = this.nk;
        this.h.put(v, new Integer(idx));
        Prototype f = this.f;
        if (f.k == null || this.nk + 1 >= f.k.length) {
            f.k = FuncState.realloc(f.k, this.nk * 2 + 1);
        }
        f.k[this.nk++] = v;
        return idx;
    }

    int stringK(LuaString s) {
        return this.addk(s);
    }

    int numberK(LuaValue r) {
        int i;
        double d;
        if (r instanceof LuaDouble && (d = r.todouble()) == (double)(i = (int)d)) {
            r = LuaInteger.valueOf(i);
        }
        return this.addk(r);
    }

    int boolK(boolean b) {
        return this.addk(b ? LuaValue.TRUE : LuaValue.FALSE);
    }

    int nilK() {
        return this.addk(LuaValue.NIL);
    }

    void setreturns(LexState.expdesc e, int nresults) {
        if (e.k == 12) {
            FuncState.SETARG_C(this.getcodePtr(e), nresults + 1);
        } else if (e.k == 13) {
            FuncState.SETARG_B(this.getcodePtr(e), nresults + 1);
            FuncState.SETARG_A(this.getcodePtr(e), this.freereg);
            this.reserveregs(1);
        }
    }

    void setoneret(LexState.expdesc e) {
        if (e.k == 12) {
            e.k = 6;
            e.u.info = FuncState.GETARG_A(this.getcode(e));
        } else if (e.k == 13) {
            FuncState.SETARG_B(this.getcodePtr(e), 2);
            e.k = 11;
        }
    }

    void dischargevars(LexState.expdesc e) {
        switch (e.k) {
            case 7: {
                e.k = 6;
                break;
            }
            case 8: {
                e.u.info = this.codeABC(5, 0, e.u.info, 0);
                e.k = 11;
                break;
            }
            case 9: {
                int op = 6;
                this.freereg(e.u.ind_idx);
                if (e.u.ind_vt == 7) {
                    this.freereg(e.u.ind_t);
                    op = 7;
                }
                e.u.info = this.codeABC(op, 0, e.u.ind_t, e.u.ind_idx);
                e.k = 11;
                break;
            }
            case 12: 
            case 13: {
                this.setoneret(e);
                break;
            }
        }
    }

    int code_label(int A, int b, int jump) {
        this.getlabel();
        return this.codeABC(3, A, b, jump);
    }

    void discharge2reg(LexState.expdesc e, int reg) {
        this.dischargevars(e);
        switch (e.k) {
            case 1: {
                this.nil(reg, 1);
                break;
            }
            case 2: 
            case 3: {
                this.codeABC(3, reg, e.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.codeABx(1, reg, e.u.info);
                break;
            }
            case 5: {
                this.codeABx(1, reg, this.numberK(e.u.nval()));
                break;
            }
            case 11: {
                InstructionPtr pc = this.getcodePtr(e);
                FuncState.SETARG_A(pc, reg);
                break;
            }
            case 6: {
                if (reg == e.u.info) break;
                this.codeABC(0, reg, e.u.info, 0);
                break;
            }
            default: {
                FuncState._assert(e.k == 0 || e.k == 10);
                return;
            }
        }
        e.u.info = reg;
        e.k = 6;
    }

    void discharge2anyreg(LexState.expdesc e) {
        if (e.k != 6) {
            this.reserveregs(1);
            this.discharge2reg(e, this.freereg - 1);
        }
    }

    void exp2reg(LexState.expdesc e, int reg) {
        this.discharge2reg(e, reg);
        if (e.k == 10) {
            this.concat(e.t, e.u.info);
        }
        if (e.hasjumps()) {
            int p_f = -1;
            int p_t = -1;
            if (this.need_value(e.t.i) || this.need_value(e.f.i)) {
                int fj = e.k == 10 ? -1 : this.jump();
                p_f = this.code_label(reg, 0, 1);
                p_t = this.code_label(reg, 1, 0);
                this.patchtohere(fj);
            }
            int _final = this.getlabel();
            this.patchlistaux(e.f.i, _final, reg, p_f);
            this.patchlistaux(e.t.i, _final, reg, p_t);
        }
        e.t.i = -1;
        e.f.i = -1;
        e.u.info = reg;
        e.k = 6;
    }

    void exp2nextreg(LexState.expdesc e) {
        this.dischargevars(e);
        this.freeexp(e);
        this.reserveregs(1);
        this.exp2reg(e, this.freereg - 1);
    }

    int exp2anyreg(LexState.expdesc e) {
        this.dischargevars(e);
        if (e.k == 6) {
            if (!e.hasjumps()) {
                return e.u.info;
            }
            if (e.u.info >= this.nactvar) {
                this.exp2reg(e, e.u.info);
                return e.u.info;
            }
        }
        this.exp2nextreg(e);
        return e.u.info;
    }

    void exp2anyregup(LexState.expdesc e) {
        if (e.k != 8 || e.hasjumps()) {
            this.exp2anyreg(e);
        }
    }

    void exp2val(LexState.expdesc e) {
        if (e.hasjumps()) {
            this.exp2anyreg(e);
        } else {
            this.dischargevars(e);
        }
    }

    int exp2RK(LexState.expdesc e) {
        this.exp2val(e);
        switch (e.k) {
            case 1: 
            case 2: 
            case 3: {
                if (this.nk > 255) break;
                e.u.info = e.k == 1 ? this.nilK() : this.boolK(e.k == 2);
                e.k = 4;
                return FuncState.RKASK(e.u.info);
            }
            case 5: {
                e.u.info = this.numberK(e.u.nval());
                e.k = 4;
            }
            case 4: {
                if (e.u.info > 255) break;
                return FuncState.RKASK(e.u.info);
            }
        }
        return this.exp2anyreg(e);
    }

    void storevar(LexState.expdesc var, LexState.expdesc ex) {
        switch (var.k) {
            case 7: {
                this.freeexp(ex);
                this.exp2reg(ex, var.u.info);
                return;
            }
            case 8: {
                int e = this.exp2anyreg(ex);
                this.codeABC(9, e, var.u.info, 0);
                break;
            }
            case 9: {
                int op = var.u.ind_vt == 7 ? 10 : 8;
                int e = this.exp2RK(ex);
                this.codeABC(op, var.u.ind_t, var.u.ind_idx, e);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        this.freeexp(ex);
    }

    void self(LexState.expdesc e, LexState.expdesc key) {
        this.exp2anyreg(e);
        this.freeexp(e);
        short func = this.freereg;
        this.reserveregs(2);
        this.codeABC(12, func, e.u.info, this.exp2RK(key));
        this.freeexp(key);
        e.u.info = func;
        e.k = 6;
    }

    void invertjump(LexState.expdesc e) {
        InstructionPtr pc = this.getjumpcontrol(e.u.info);
        FuncState._assert(FuncState.testTMode(FuncState.GET_OPCODE(pc.get())) && FuncState.GET_OPCODE(pc.get()) != 28 && Lua.GET_OPCODE(pc.get()) != 27);
        int a = FuncState.GETARG_A(pc.get());
        int nota = a != 0 ? 0 : 1;
        FuncState.SETARG_A(pc, nota);
    }

    int jumponcond(LexState.expdesc e, int cond) {
        int ie;
        if (e.k == 11 && FuncState.GET_OPCODE(ie = this.getcode(e)) == 20) {
            --this.pc;
            return this.condjump(27, FuncState.GETARG_B(ie), 0, cond != 0 ? 0 : 1);
        }
        this.discharge2anyreg(e);
        this.freeexp(e);
        return this.condjump(28, 255, e.u.info, cond);
    }

    void goiftrue(LexState.expdesc e) {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 10: {
                this.invertjump(e);
                pc = e.u.info;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                pc = -1;
                break;
            }
            default: {
                pc = this.jumponcond(e, 0);
            }
        }
        this.concat(e.f, pc);
        this.patchtohere(e.t.i);
        e.t.i = -1;
    }

    void goiffalse(LexState.expdesc e) {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 10: {
                pc = e.u.info;
                break;
            }
            case 1: 
            case 3: {
                pc = -1;
                break;
            }
            default: {
                pc = this.jumponcond(e, 1);
            }
        }
        this.concat(e.t, pc);
        this.patchtohere(e.f.i);
        e.f.i = -1;
    }

    void codenot(LexState.expdesc e) {
        this.dischargevars(e);
        switch (e.k) {
            case 1: 
            case 3: {
                e.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                e.k = 3;
                break;
            }
            case 10: {
                this.invertjump(e);
                break;
            }
            case 6: 
            case 11: {
                this.discharge2anyreg(e);
                this.freeexp(e);
                e.u.info = this.codeABC(20, 0, e.u.info, 0);
                e.k = 11;
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        int temp = e.f.i;
        e.f.i = e.t.i;
        e.t.i = temp;
        this.removevalues(e.f.i);
        this.removevalues(e.t.i);
    }

    static boolean vkisinreg(int k) {
        return k == 6 || k == 7;
    }

    void indexed(LexState.expdesc t, LexState.expdesc k) {
        t.u.ind_t = (short)t.u.info;
        t.u.ind_idx = (short)this.exp2RK(k);
        LuaC._assert(t.k == 8 || FuncState.vkisinreg(t.k));
        t.u.ind_vt = (short)(t.k == 8 ? 8 : 7);
        t.k = 9;
    }

    boolean constfolding(int op, LexState.expdesc e1, LexState.expdesc e2) {
        LuaValue r;
        if (!e1.isnumeral() || !e2.isnumeral()) {
            return false;
        }
        if ((op == 16 || op == 17) && e2.u.nval().eq_b(LuaValue.ZERO)) {
            return false;
        }
        LuaValue v1 = e1.u.nval();
        LuaValue v2 = e2.u.nval();
        switch (op) {
            case 13: {
                r = v1.add(v2);
                break;
            }
            case 14: {
                r = v1.sub(v2);
                break;
            }
            case 15: {
                r = v1.mul(v2);
                break;
            }
            case 16: {
                r = v1.div(v2);
                break;
            }
            case 17: {
                r = v1.mod(v2);
                break;
            }
            case 18: {
                r = v1.pow(v2);
                break;
            }
            case 19: {
                r = v1.neg();
                break;
            }
            case 21: {
                return false;
            }
            default: {
                FuncState._assert(false);
                r = null;
            }
        }
        if (Double.isNaN(r.todouble())) {
            return false;
        }
        e1.u.setNval(r);
        return true;
    }

    void codearith(int op, LexState.expdesc e1, LexState.expdesc e2, int line) {
        if (this.constfolding(op, e1, e2)) {
            return;
        }
        int o2 = op != 19 && op != 21 ? this.exp2RK(e2) : 0;
        int o1 = this.exp2RK(e1);
        if (o1 > o2) {
            this.freeexp(e1);
            this.freeexp(e2);
        } else {
            this.freeexp(e2);
            this.freeexp(e1);
        }
        e1.u.info = this.codeABC(op, 0, o1, o2);
        e1.k = 11;
        this.fixline(line);
    }

    void codecomp(int op, int cond, LexState.expdesc e1, LexState.expdesc e2) {
        int o1 = this.exp2RK(e1);
        int o2 = this.exp2RK(e2);
        this.freeexp(e2);
        this.freeexp(e1);
        if (cond == 0 && op != 24) {
            int temp = o1;
            o1 = o2;
            o2 = temp;
            cond = 1;
        }
        e1.u.info = this.condjump(op, cond, o1, o2);
        e1.k = 10;
    }

    void prefix(int op, LexState.expdesc e, int line) {
        LexState.expdesc e2 = new LexState.expdesc();
        e2.init(5, 0);
        switch (op) {
            case 0: {
                if (e.isnumeral()) {
                    e.u.setNval(e.u.nval().neg());
                    break;
                }
                this.exp2anyreg(e);
                this.codearith(19, e, e2, line);
                break;
            }
            case 1: {
                this.codenot(e);
                break;
            }
            case 2: {
                this.exp2anyreg(e);
                this.codearith(21, e, e2, line);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void infix(int op, LexState.expdesc v) {
        switch (op) {
            case 13: {
                this.goiftrue(v);
                break;
            }
            case 14: {
                this.goiffalse(v);
                break;
            }
            case 6: {
                this.exp2nextreg(v);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (v.isnumeral()) break;
                this.exp2RK(v);
                break;
            }
            default: {
                this.exp2RK(v);
            }
        }
    }

    void posfix(int op, LexState.expdesc e1, LexState.expdesc e2, int line) {
        switch (op) {
            case 13: {
                FuncState._assert(e1.t.i == -1);
                this.dischargevars(e2);
                this.concat(e2.f, e1.f.i);
                e1.setvalue(e2);
                break;
            }
            case 14: {
                FuncState._assert(e1.f.i == -1);
                this.dischargevars(e2);
                this.concat(e2.t, e1.t.i);
                e1.setvalue(e2);
                break;
            }
            case 6: {
                this.exp2val(e2);
                if (e2.k == 11 && FuncState.GET_OPCODE(this.getcode(e2)) == 22) {
                    FuncState._assert(e1.u.info == FuncState.GETARG_B(this.getcode(e2)) - 1);
                    this.freeexp(e1);
                    FuncState.SETARG_B(this.getcodePtr(e2), e1.u.info);
                    e1.k = 11;
                    e1.u.info = e2.u.info;
                    break;
                }
                this.exp2nextreg(e2);
                this.codearith(22, e1, e2, line);
                break;
            }
            case 0: {
                this.codearith(13, e1, e2, line);
                break;
            }
            case 1: {
                this.codearith(14, e1, e2, line);
                break;
            }
            case 2: {
                this.codearith(15, e1, e2, line);
                break;
            }
            case 3: {
                this.codearith(16, e1, e2, line);
                break;
            }
            case 4: {
                this.codearith(17, e1, e2, line);
                break;
            }
            case 5: {
                this.codearith(18, e1, e2, line);
                break;
            }
            case 8: {
                this.codecomp(24, 1, e1, e2);
                break;
            }
            case 7: {
                this.codecomp(24, 0, e1, e2);
                break;
            }
            case 9: {
                this.codecomp(25, 1, e1, e2);
                break;
            }
            case 10: {
                this.codecomp(26, 1, e1, e2);
                break;
            }
            case 11: {
                this.codecomp(25, 0, e1, e2);
                break;
            }
            case 12: {
                this.codecomp(26, 0, e1, e2);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void fixline(int line) {
        this.f.lineinfo[this.pc - 1] = line;
    }

    int code(int instruction, int line) {
        Prototype f = this.f;
        this.dischargejpc();
        if (f.code == null || this.pc + 1 > f.code.length) {
            f.code = LuaC.realloc(f.code, this.pc * 2 + 1);
        }
        f.code[this.pc] = instruction;
        if (f.lineinfo == null || this.pc + 1 > f.lineinfo.length) {
            f.lineinfo = LuaC.realloc(f.lineinfo, this.pc * 2 + 1);
        }
        f.lineinfo[this.pc] = line;
        return this.pc++;
    }

    int codeABC(int o, int a, int b, int c) {
        FuncState._assert(FuncState.getOpMode(o) == 0);
        FuncState._assert(FuncState.getBMode(o) != 0 || b == 0);
        FuncState._assert(FuncState.getCMode(o) != 0 || c == 0);
        return this.code(FuncState.CREATE_ABC(o, a, b, c), this.ls.lastline);
    }

    int codeABx(int o, int a, int bc) {
        FuncState._assert(FuncState.getOpMode(o) == 1 || FuncState.getOpMode(o) == 2);
        FuncState._assert(FuncState.getCMode(o) == 0);
        FuncState._assert(bc >= 0 && bc <= 262143);
        return this.code(FuncState.CREATE_ABx(o, a, bc), this.ls.lastline);
    }

    void setlist(int base, int nelems, int tostore) {
        int c = (nelems - 1) / 50 + 1;
        int b = tostore == -1 ? 0 : tostore;
        FuncState._assert(tostore != 0);
        if (c <= 511) {
            this.codeABC(36, base, b, c);
        } else {
            this.codeABC(36, base, b, 0);
            this.code(c, this.ls.lastline);
        }
        this.freereg = (short)(base + 1);
    }

    static class BlockCnt {
        BlockCnt previous;
        short firstlabel;
        short firstgoto;
        short nactvar;
        boolean upval;
        boolean isloop;

        BlockCnt() {
        }
    }
}

