/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;

public class LuaDouble
extends LuaNumber {
    public static final LuaDouble NAN = new LuaDouble(Double.NaN);
    public static final LuaDouble POSINF = new LuaDouble(Double.POSITIVE_INFINITY);
    public static final LuaDouble NEGINF = new LuaDouble(Double.NEGATIVE_INFINITY);
    public static final String JSTR_NAN = "nan";
    public static final String JSTR_POSINF = "inf";
    public static final String JSTR_NEGINF = "-inf";
    final double v;

    public static LuaNumber valueOf(double d) {
        int id = (int)d;
        return d == (double)id ? LuaInteger.valueOf(id) : new LuaDouble(d);
    }

    private LuaDouble(double d) {
        this.v = d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.v + 1.0);
        return (int)(l >> 32) + (int)l;
    }

    @Override
    public boolean islong() {
        return this.v == (double)((long)this.v);
    }

    @Override
    public byte tobyte() {
        return (byte)this.v;
    }

    @Override
    public char tochar() {
        return (char)this.v;
    }

    @Override
    public double todouble() {
        return this.v;
    }

    @Override
    public float tofloat() {
        return (float)this.v;
    }

    @Override
    public int toint() {
        return (int)this.v;
    }

    @Override
    public long tolong() {
        return (long)this.v;
    }

    @Override
    public short toshort() {
        return (short)this.v;
    }

    @Override
    public double optdouble(double defval) {
        return this.v;
    }

    @Override
    public int optint(int defval) {
        return (int)this.v;
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return LuaInteger.valueOf((int)this.v);
    }

    @Override
    public long optlong(long defval) {
        return (long)this.v;
    }

    @Override
    public LuaInteger checkinteger() {
        return LuaInteger.valueOf((int)this.v);
    }

    @Override
    public LuaValue neg() {
        return LuaDouble.valueOf(-this.v);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LuaDouble ? ((LuaDouble)o).v == this.v : false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this.v) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(double val) {
        return this.v == val;
    }

    @Override
    public boolean raweq(int val) {
        return this.v == (double)val;
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        return rhs.add(this.v);
    }

    @Override
    public LuaValue add(double lhs) {
        return LuaDouble.valueOf(lhs + this.v);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        return rhs.subFrom(this.v);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaDouble.valueOf(this.v - rhs);
    }

    @Override
    public LuaValue sub(int rhs) {
        return LuaDouble.valueOf(this.v - (double)rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaDouble.valueOf(lhs - this.v);
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        return rhs.mul(this.v);
    }

    @Override
    public LuaValue mul(double lhs) {
        return LuaDouble.valueOf(lhs * this.v);
    }

    @Override
    public LuaValue mul(int lhs) {
        return LuaDouble.valueOf((double)lhs * this.v);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        return rhs.powWith(this.v);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.v, rhs);
    }

    @Override
    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.v, rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.v);
    }

    @Override
    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.v);
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        return rhs.divInto(this.v);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.v, rhs);
    }

    @Override
    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.v, rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.v);
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        return rhs.modFrom(this.v);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.v, rhs);
    }

    @Override
    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.v, rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.v);
    }

    public static LuaValue ddiv(double lhs, double rhs) {
        return rhs != 0.0 ? LuaDouble.valueOf(lhs / rhs) : (lhs > 0.0 ? POSINF : (lhs == 0.0 ? NAN : NEGINF));
    }

    public static double ddiv_d(double lhs, double rhs) {
        return rhs != 0.0 ? lhs / rhs : (lhs > 0.0 ? Double.POSITIVE_INFINITY : (lhs == 0.0 ? Double.NaN : Double.NEGATIVE_INFINITY));
    }

    public static LuaValue dmod(double lhs, double rhs) {
        return rhs != 0.0 ? LuaDouble.valueOf(lhs - rhs * Math.floor(lhs / rhs)) : NAN;
    }

    public static double dmod_d(double lhs, double rhs) {
        return rhs != 0.0 ? lhs - rhs * Math.floor(lhs / rhs) : Double.NaN;
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs.gt_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    @Override
    public LuaValue lt(double rhs) {
        return this.v < rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue lt(int rhs) {
        return this.v < (double)rhs ? TRUE : FALSE;
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs.gt_b(this.v);
    }

    @Override
    public boolean lt_b(int rhs) {
        return this.v < (double)rhs;
    }

    @Override
    public boolean lt_b(double rhs) {
        return this.v < rhs;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs.gteq_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    @Override
    public LuaValue lteq(double rhs) {
        return this.v <= rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue lteq(int rhs) {
        return this.v <= (double)rhs ? TRUE : FALSE;
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs.gteq_b(this.v);
    }

    @Override
    public boolean lteq_b(int rhs) {
        return this.v <= (double)rhs;
    }

    @Override
    public boolean lteq_b(double rhs) {
        return this.v <= rhs;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs.lt_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    @Override
    public LuaValue gt(double rhs) {
        return this.v > rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue gt(int rhs) {
        return this.v > (double)rhs ? TRUE : FALSE;
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs.lt_b(this.v);
    }

    @Override
    public boolean gt_b(int rhs) {
        return this.v > (double)rhs;
    }

    @Override
    public boolean gt_b(double rhs) {
        return this.v > rhs;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs.lteq_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    @Override
    public LuaValue gteq(double rhs) {
        return this.v >= rhs ? TRUE : FALSE;
    }

    @Override
    public LuaValue gteq(int rhs) {
        return this.v >= (double)rhs ? TRUE : FALSE;
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs.lteq_b(this.v);
    }

    @Override
    public boolean gteq_b(int rhs) {
        return this.v >= (double)rhs;
    }

    @Override
    public boolean gteq_b(double rhs) {
        return this.v >= rhs;
    }

    @Override
    public int strcmp(LuaString rhs) {
        this.typerror("attempt to compare number with string");
        return 0;
    }

    @Override
    public String tojstring() {
        long l = (long)this.v;
        if ((double)l == this.v) {
            return Long.toString(l);
        }
        if (Double.isNaN(this.v)) {
            return JSTR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? JSTR_NEGINF : JSTR_POSINF;
        }
        return Float.toString((float)this.v);
    }

    @Override
    public LuaString strvalue() {
        return LuaString.valueOf(this.tojstring());
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return LuaString.valueOf(this.tojstring());
    }

    @Override
    public LuaValue tostring() {
        return LuaString.valueOf(this.tojstring());
    }

    @Override
    public String optjstring(String defval) {
        return this.tojstring();
    }

    @Override
    public LuaNumber optnumber(LuaNumber defval) {
        return this;
    }

    @Override
    public boolean isnumber() {
        return true;
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    public LuaValue tonumber() {
        return this;
    }

    @Override
    public int checkint() {
        return (int)this.v;
    }

    @Override
    public long checklong() {
        return (long)this.v;
    }

    @Override
    public LuaNumber checknumber() {
        return this;
    }

    @Override
    public double checkdouble() {
        return this.v;
    }

    @Override
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    public LuaString checkstring() {
        return LuaString.valueOf(this.tojstring());
    }

    @Override
    public boolean isvalidkey() {
        return !Double.isNaN(this.v);
    }
}

