/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;

public class LoadState {
    public static final Globals.Undumper instance = new GlobalsUndumper();
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int LUA_TINT = -2;
    public static final int LUA_TNONE = -1;
    public static final int LUA_TNIL = 0;
    public static final int LUA_TBOOLEAN = 1;
    public static final int LUA_TLIGHTUSERDATA = 2;
    public static final int LUA_TNUMBER = 3;
    public static final int LUA_TSTRING = 4;
    public static final int LUA_TTABLE = 5;
    public static final int LUA_TFUNCTION = 6;
    public static final int LUA_TUSERDATA = 7;
    public static final int LUA_TTHREAD = 8;
    public static final int LUA_TVALUE = 9;
    public static String encoding = null;
    public static final byte[] LUA_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static final byte[] LUAC_TAIL = new byte[]{25, -109, 13, 10, 26, 10};
    public static final String SOURCE_BINARY_STRING = "binary string";
    public static final int LUAC_VERSION = 82;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private int luacVersion;
    private int luacFormat;
    private boolean luacLittleEndian;
    private int luacSizeofInt;
    private int luacSizeofSizeT;
    private int luacSizeofInstruction;
    private int luacSizeofLuaNumber;
    private int luacNumberFormat;
    public final DataInputStream is;
    String name;
    private static final LuaValue[] NOVALUES = new LuaValue[0];
    private static final Prototype[] NOPROTOS = new Prototype[0];
    private static final LocVars[] NOLOCVARS = new LocVars[0];
    private static final LuaString[] NOSTRVALUES = new LuaString[0];
    private static final Upvaldesc[] NOUPVALDESCS = new Upvaldesc[0];
    private static final int[] NOINTS = new int[0];
    private byte[] buf = new byte[512];

    public static void install(Globals globals) {
        globals.undumper = instance;
    }

    int loadInt() throws IOException {
        this.is.readFully(this.buf, 0, 4);
        return this.luacLittleEndian ? this.buf[3] << 24 | (0xFF & this.buf[2]) << 16 | (0xFF & this.buf[1]) << 8 | 0xFF & this.buf[0] : this.buf[0] << 24 | (0xFF & this.buf[1]) << 16 | (0xFF & this.buf[2]) << 8 | 0xFF & this.buf[3];
    }

    int[] loadIntArray() throws IOException {
        int n = this.loadInt();
        if (n == 0) {
            return NOINTS;
        }
        int m = n << 2;
        if (this.buf.length < m) {
            this.buf = new byte[m];
        }
        this.is.readFully(this.buf, 0, m);
        int[] array = new int[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            array[i] = this.luacLittleEndian ? this.buf[j + 3] << 24 | (0xFF & this.buf[j + 2]) << 16 | (0xFF & this.buf[j + 1]) << 8 | 0xFF & this.buf[j + 0] : this.buf[j + 0] << 24 | (0xFF & this.buf[j + 1]) << 16 | (0xFF & this.buf[j + 2]) << 8 | 0xFF & this.buf[j + 3];
            ++i;
            j += 4;
        }
        return array;
    }

    long loadInt64() throws IOException {
        int b;
        int a;
        if (this.luacLittleEndian) {
            a = this.loadInt();
            b = this.loadInt();
        } else {
            b = this.loadInt();
            a = this.loadInt();
        }
        return (long)b << 32 | (long)a & 0xFFFFFFFFL;
    }

    LuaString loadString() throws IOException {
        int size;
        int n = size = this.luacSizeofSizeT == 8 ? (int)this.loadInt64() : this.loadInt();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        this.is.readFully(bytes, 0, size);
        return LuaString.valueUsing(bytes, 0, bytes.length - 1);
    }

    public static LuaValue longBitsToLuaNumber(long bits) {
        int shift;
        long intPrecMask;
        long f;
        if ((bits & Long.MAX_VALUE) == 0L) {
            return LuaValue.ZERO;
        }
        int e = (int)(bits >> 52 & 0x7FFL) - 1023;
        if (e >= 0 && e < 31 && ((f = bits & 0xFFFFFFFFFFFFFL) & (intPrecMask = (1L << (shift = 52 - e)) - 1L)) == 0L) {
            int intValue = (int)(f >> shift) | 1 << e;
            return LuaInteger.valueOf(bits >> 63 != 0L ? -intValue : intValue);
        }
        return LuaValue.valueOf(Double.longBitsToDouble(bits));
    }

    LuaValue loadNumber() throws IOException {
        if (this.luacNumberFormat == 1) {
            return LuaInteger.valueOf(this.loadInt());
        }
        return LoadState.longBitsToLuaNumber(this.loadInt64());
    }

    void loadConstants(Prototype f) throws IOException {
        int n = this.loadInt();
        LuaValue[] values = n > 0 ? new LuaValue[n] : NOVALUES;
        int i = 0;
        while (i < n) {
            switch (this.is.readByte()) {
                case 0: {
                    values[i] = LuaValue.NIL;
                    break;
                }
                case 1: {
                    values[i] = this.is.readUnsignedByte() != 0 ? LuaValue.TRUE : LuaValue.FALSE;
                    break;
                }
                case -2: {
                    values[i] = LuaInteger.valueOf(this.loadInt());
                    break;
                }
                case 3: {
                    values[i] = this.loadNumber();
                    break;
                }
                case 4: {
                    values[i] = this.loadString();
                    break;
                }
                default: {
                    throw new IllegalStateException("bad constant");
                }
            }
            ++i;
        }
        f.k = values;
        n = this.loadInt();
        Prototype[] protos = n > 0 ? new Prototype[n] : NOPROTOS;
        int i2 = 0;
        while (i2 < n) {
            protos[i2] = this.loadFunction(f.source);
            ++i2;
        }
        f.p = protos;
    }

    void loadUpvalues(Prototype f) throws IOException {
        int n = this.loadInt();
        f.upvalues = n > 0 ? new Upvaldesc[n] : NOUPVALDESCS;
        int i = 0;
        while (i < n) {
            boolean instack = this.is.readByte() != 0;
            int idx = this.is.readByte() & 0xFF;
            f.upvalues[i] = new Upvaldesc(null, instack, idx);
            ++i;
        }
    }

    void loadDebug(Prototype f) throws IOException {
        f.source = this.loadString();
        f.lineinfo = this.loadIntArray();
        int n = this.loadInt();
        f.locvars = n > 0 ? new LocVars[n] : NOLOCVARS;
        int i = 0;
        while (i < n) {
            LuaString varname = this.loadString();
            int startpc = this.loadInt();
            int endpc = this.loadInt();
            f.locvars[i] = new LocVars(varname, startpc, endpc);
            ++i;
        }
        n = this.loadInt();
        i = 0;
        while (i < n) {
            f.upvalues[i].name = this.loadString();
            ++i;
        }
    }

    public Prototype loadFunction(LuaString p) throws IOException {
        Prototype f = new Prototype();
        f.linedefined = this.loadInt();
        f.lastlinedefined = this.loadInt();
        f.numparams = this.is.readUnsignedByte();
        f.is_vararg = this.is.readUnsignedByte();
        f.maxstacksize = this.is.readUnsignedByte();
        f.code = this.loadIntArray();
        this.loadConstants(f);
        this.loadUpvalues(f);
        this.loadDebug(f);
        return f;
    }

    public void loadHeader() throws IOException {
        this.luacVersion = this.is.readByte();
        this.luacFormat = this.is.readByte();
        this.luacLittleEndian = this.is.readByte() != 0;
        this.luacSizeofInt = this.is.readByte();
        this.luacSizeofSizeT = this.is.readByte();
        this.luacSizeofInstruction = this.is.readByte();
        this.luacSizeofLuaNumber = this.is.readByte();
        this.luacNumberFormat = this.is.readByte();
        int i = 0;
        while (i < LUAC_TAIL.length) {
            if (this.is.readByte() != LUAC_TAIL[i]) {
                throw new LuaError("Unexpeted byte in luac tail of header, index=" + i);
            }
            ++i;
        }
    }

    public static Prototype undump(InputStream stream, String chunkname) throws IOException {
        if (stream.read() != LUA_SIGNATURE[0] || stream.read() != LUA_SIGNATURE[1] || stream.read() != LUA_SIGNATURE[2] || stream.read() != LUA_SIGNATURE[3]) {
            return null;
        }
        String sname = LoadState.getSourceName(chunkname);
        LoadState s = new LoadState(stream, sname);
        s.loadHeader();
        switch (s.luacNumberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new LuaError("unsupported int size");
            }
        }
        return s.loadFunction(LuaString.valueOf(sname));
    }

    public static String getSourceName(String name) {
        String sname = name;
        if (name.startsWith("@") || name.startsWith("=")) {
            sname = name.substring(1);
        } else if (name.startsWith("\u001b")) {
            sname = SOURCE_BINARY_STRING;
        }
        return sname;
    }

    private LoadState(InputStream stream, String name) {
        this.name = name;
        this.is = new DataInputStream(stream);
    }

    private static final class GlobalsUndumper
    implements Globals.Undumper {
        private GlobalsUndumper() {
        }

        @Override
        public Prototype undump(InputStream stream, String chunkname) throws IOException {
            return LoadState.undump(stream, chunkname);
        }
    }
}

