/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Thrown Potion")
@Description(value={"The potion that is thrown in a 'Witch Throws Potion' event. If setting, the potion must be a splash potion."})
@Examples(value={"on witch throws potion", "\tset witch's thrown potion to splash potion of speed"})
@Events(value={"Witch Throws Potion"})
@RequiredPlugins(value={"Paper 1.12.2+"})
@Since(value="1.1.0")
public class ExprThrownPotion
extends SimpleExpression<ItemType> {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ItemType[] get(Event e) {
        ItemStack item = ((WitchThrowPotionEvent)e).getPotion();
        ItemType it = new ItemType(item);
        return new ItemType[]{it};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ItemType.class};
        }
        return null;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(WitchThrowPotionEvent.class)) {
            Skript.error((String)"The expression 'thrown potion' may only be used in Witch Throw Potion events", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemType item = delta == null ? null : (ItemType)delta[0];
        switch (mode) {
            case SET: {
                if (item == null) break;
                ((WitchThrowPotionEvent)e).setPotion(item.getRandom());
                break;
            }
            case REMOVE: 
            case ADD: 
            case RESET: 
            case DELETE: 
            case REMOVE_ALL: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    static {
        boolean bl = $assertionsDisabled = !ExprThrownPotion.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft((int)1, (int)12, (int)2)) {
            Skript.registerExpression(ExprThrownPotion.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] witch['s] thrown potion"});
        }
    }
}

