/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Knockback Attacker/Victim")
@Description(value={"The attacker/victim in an entity knockback event"})
@Examples(value={"on entity knockback:", "\tif knockback attacker is a player:", "\t\tif knockback victim is a sheep:", "\t\t\tcancel event"})
@RequiredPlugins(value={"Paper 1.12.2+"})
@Since(value="1.1.0")
public class ExprKnockbackAttackerVictim
extends SimpleExpression<Entity> {
    private Integer ent;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(EntityKnockbackByEntityEvent.class)) {
            Skript.error((String)"Can not use 'knockback attacker/victim' outside of knockback event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.ent = parseResult.mark;
        return true;
    }

    protected Entity[] get(Event e) {
        if (this.ent == 0) {
            return new Entity[]{ExprKnockbackAttackerVictim.getAttacker(e)};
        }
        if (this.ent == 1) {
            return new Entity[]{ExprKnockbackAttackerVictim.getVictim(e)};
        }
        return null;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Nullable
    private static Entity getAttacker(@Nullable Event e) {
        if (e == null) {
            return null;
        }
        if (e instanceof EntityKnockbackByEntityEvent) {
            return ((EntityKnockbackByEntityEvent)e).getHitBy();
        }
        return null;
    }

    @Nullable
    private static Entity getVictim(@Nullable Event e) {
        if (e == null) {
            return null;
        }
        if (e instanceof EntityKnockbackByEntityEvent) {
            return ((EntityKnockbackByEntityEvent)e).getEntity();
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return this.ent == 1 ? "knockback victim" : "knockback attacker";
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)12, (int)2)) {
            Skript.registerExpression(ExprKnockbackAttackerVictim.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] knockback (0\u00a6attacker|1\u00a6victim)"});
        }
    }
}

