/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="View Distance of Player")
@Description(value={"Get and set the view distance for players. Reset will set the view distance to match the server's view distance."})
@Examples(value={"send \"View: %view distance of player%\"set {_view} to view distance of playerset view distance of player to 10set view distance of all players to 5reset view distance of all players"})
@RequiredPlugins(value={"Paper 1.13.2+"})
@Since(value="1.3.0")
public class ExprPlayerViewDistance
extends PropertyExpression<Player, Integer> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Integer[] get(Event event, Player[] players) {
        return (Integer[])this.get(players, (Converter)new Getter<Integer, Player>(){

            public Integer get(Player player) {
                return player.getViewDistance();
            }
        });
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double d = delta == null ? 0.0 : ((Number)delta[0]).doubleValue();
        int view = Double.valueOf(d).intValue();
        switch (mode) {
            case SET: {
                for (Player p : (Player[])this.getExpr().getArray(e)) {
                    p.setViewDistance(view);
                }
                break;
            }
            case RESET: {
                for (Player p : (Player[])this.getExpr().getArray(e)) {
                    view = Bukkit.getServer().getViewDistance();
                    p.setViewDistance(view);
                }
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public String toString(Event e, boolean debug) {
        return "view distance of " + this.getExpr().toString(e, debug);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13, (int)2)) {
            ExprPlayerViewDistance.register(ExprPlayerViewDistance.class, Integer.class, (String)"[client] view distance", (String)"players");
        }
    }
}

