/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Consumed Potion")
@Description(value={"The potion that is consumed in a 'Witch Consumed Potion' event."})
@Examples(value={"on witch consume potion:", "\tset witch's consumed potion to strong potion of instant damage"})
@Events(value={"Witch Consume Potion"})
@RequiredPlugins(value={"Paper 1.12.2+"})
@Since(value="1.1.0")
public class ExprConsumedPotion
extends SimpleExpression<ItemStack> {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ItemStack[] get(Event e) {
        return new ItemStack[]{((WitchConsumePotionEvent)e).getPotion()};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ItemStack.class};
        }
        return null;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(WitchConsumePotionEvent.class)) {
            Skript.error((String)"The expression 'consumed potion' may only be used in Witch Consume Potion events", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ItemStack item = delta == null ? null : (ItemStack)delta[0];
        switch (mode) {
            case SET: {
                ((WitchConsumePotionEvent)e).setPotion(item);
                break;
            }
            case REMOVE: 
            case ADD: 
            case RESET: 
            case DELETE: 
            case REMOVE_ALL: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    static {
        boolean bl = $assertionsDisabled = !ExprConsumedPotion.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft((int)1, (int)12, (int)2)) {
            Skript.registerExpression(ExprConsumedPotion.class, ItemStack.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] witch['s] (consumed|drank) potion"});
        }
    }
}

