/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.annotation.Nullable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Arrows Stuck")
@Description(value={"The number of arrows stuck in an entity (based on testing this only seems to work for a player)"})
@Examples(value={"set arrows stuck of player to 10", "add 10 to arrows stuck of player", "remove 10 from player's stuck arrows", "delete arrows stuck of player"})
@RequiredPlugins(value={"Paper 1.9.4+"})
@Since(value="1.1.0")
public class ExprArrowsStuck
extends SimplePropertyExpression<LivingEntity, Integer> {
    static final /* synthetic */ boolean $assertionsDisabled;

    @Nullable
    public Integer convert(LivingEntity t) {
        return t.getArrowsStuck();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int d = delta == null ? 0 : ((Number)delta[0]).intValue();
        block7: for (LivingEntity en : (LivingEntity[])this.getExpr().getArray(e)) {
            if (!$assertionsDisabled && en == null) {
                throw new AssertionError(this.getExpr());
            }
            switch (mode) {
                case SET: {
                    en.setArrowsStuck(d);
                    continue block7;
                }
                case REMOVE: {
                    d = -d;
                }
                case ADD: {
                    en.setArrowsStuck(en.getArrowsStuck() + d);
                    continue block7;
                }
                case RESET: 
                case DELETE: {
                    en.setArrowsStuck(0);
                    continue block7;
                }
                case REMOVE_ALL: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block7;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "arrows stuck";
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    static {
        boolean bl = $assertionsDisabled = !ExprArrowsStuck.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft((int)1, (int)9, (int)4)) {
            ExprArrowsStuck.register(ExprArrowsStuck.class, Integer.class, (String)"[number of] (arrows stuck|stuck arrows)", (String)"livingentity");
        }
    }
}

