/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import com.destroystokyo.paper.event.entity.EnderDragonFireballHitEvent;
import com.destroystokyo.paper.event.entity.EnderDragonShootFireballEvent;
import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.entity.EntityZapEvent;
import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.destroystokyo.paper.event.entity.SkeletonHorseTrapEvent;
import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;

public class SimpleEvents {
    static {
        Skript.registerEvent((String)"Beacon Effect", SimpleEvent.class, BeaconEffectEvent.class, (String[])new String[]{"beacon effect"}).description(new String[]{"Called when a beacon effect is being applied to a player."}).examples(new String[]{"ToDo"}).requiredPlugins(new String[]{"Paper 1.9+"}).since("1.0.0");
        EventValues.registerEventValue(BeaconEffectEvent.class, Player.class, (Getter)new Getter<Player, BeaconEffectEvent>(){

            public Player get(BeaconEffectEvent e) {
                return e.getPlayer();
            }
        }, (int)0);
        if (Skript.isRunningMinecraft((int)1, (int)10, (int)2)) {
            Skript.registerEvent((String)"Entity Zap", SimpleEvent.class, EntityZapEvent.class, (String[])new String[]{"entity (zap|struck by lightning)"}).description(new String[]{"Fired when lightning strikes an entity"}).examples(new String[]{"on entity zap:", "\tif event-entity is a pig:", "\t\tspawn 3 zombie pigmen at event-location"}).requiredPlugins(new String[]{"Paper 1.10.2+"}).since("1.0.0");
        }
        if (Skript.isRunningMinecraft((int)1, (int)11, (int)2)) {
            Skript.registerEvent((String)"Projectile Collide", SimpleEvent.class, ProjectileCollideEvent.class, (String[])new String[]{"projectile collide"}).description(new String[]{"Called when an projectile collides with an entity (This event is called before entity damage event, and cancelling it will allow the projectile to continue flying)"}).examples(new String[]{"on projectile collide:", "\tif event-entity is a player:", "\t\tcancel event"}).requiredPlugins(new String[]{"Paper 1.11.2+"}).since("1.0.0");
            EventValues.registerEventValue(ProjectileCollideEvent.class, Entity.class, (Getter)new Getter<Entity, ProjectileCollideEvent>(){

                public Entity get(ProjectileCollideEvent e) {
                    return e.getCollidedWith();
                }
            }, (int)0);
            EventValues.registerEventValue(ProjectileCollideEvent.class, Projectile.class, (Getter)new Getter<Projectile, ProjectileCollideEvent>(){

                public Projectile get(ProjectileCollideEvent e) {
                    return e.getEntity();
                }
            }, (int)0);
        }
        if (Skript.isRunningMinecraft((int)1, (int)12, (int)2)) {
            Skript.registerEvent((String)"Enderman Attack Player", SimpleEvent.class, EndermanAttackPlayerEvent.class, (String[])new String[]{"ender(man|men) attack [player]"}).description(new String[]{"Fired when an Enderman determines if it should attack a player or not. Starts off cancelled if the player is wearing a pumpkin head or is not looking at the Enderman, according to Vanilla rules."}).examples(new String[]{"on enderman attack:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            EventValues.registerEventValue(EndermanAttackPlayerEvent.class, Player.class, (Getter)new Getter<Player, EndermanAttackPlayerEvent>(){

                public Player get(EndermanAttackPlayerEvent e) {
                    return e.getPlayer();
                }
            }, (int)0);
            EventValues.registerEventValue(EndermanAttackPlayerEvent.class, Entity.class, (Getter)new Getter<Entity, EndermanAttackPlayerEvent>(){

                public Entity get(EndermanAttackPlayerEvent e) {
                    return e.getEntity();
                }
            }, (int)0);
            Skript.registerEvent((String)"Entity Knockback", SimpleEvent.class, EntityKnockbackByEntityEvent.class, (String[])new String[]{"entity knockback"}).description(new String[]{"Fired when an Entity is knocked back by the hit of another Entity. If this event is cancelled, the entity is not knocked back."}).examples(new String[]{"on entity knockback:", "\tif event-entity is a cow:", "\t\tcancel event"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Experience Orb Merge", SimpleEvent.class, ExperienceOrbMergeEvent.class, (String[])new String[]{"(experience|xp) orb merge"}).description(new String[]{"Fired anytime the server is about to merge 2 experience orbs into one"}).examples(new String[]{"on xp merge:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Witch Consume Potion", SimpleEvent.class, WitchConsumePotionEvent.class, (String[])new String[]{"witch (consume[s]|drink[s]) [a] potion"}).description(new String[]{"Fired when a witch consumes the potion in their hand to buff themselves."}).examples(new String[]{"on witch consume potion", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            EventValues.registerEventValue(WitchConsumePotionEvent.class, ItemType.class, (Getter)new Getter<ItemType, WitchConsumePotionEvent>(){

                public ItemType get(WitchConsumePotionEvent e) {
                    ItemStack item = e.getPotion();
                    ItemType type = new ItemType(item);
                    return type;
                }
            }, (int)0);
            Skript.registerEvent((String)"Witch Throw Potion", SimpleEvent.class, WitchThrowPotionEvent.class, (String[])new String[]{"witch throw[s] [a] potion"}).description(new String[]{"Fired when a witch throws a potion at a player"}).examples(new String[]{"on witch throw potion", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            EventValues.registerEventValue(WitchThrowPotionEvent.class, ItemType.class, (Getter)new Getter<ItemType, WitchThrowPotionEvent>(){

                public ItemType get(WitchThrowPotionEvent e) {
                    ItemStack item = e.getPotion();
                    ItemType it = new ItemType(item);
                    return it;
                }
            }, (int)0);
            Skript.registerEvent((String)"Player Change Armor", SimpleEvent.class, PlayerArmorChangeEvent.class, (String[])new String[]{"player change armor"}).description(new String[]{"Called when the player themselves change their armor items"}).examples(new String[]{"on player change armor:", "\tcancel event", "\tset helmet of player to pumpkin"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            EventValues.registerEventValue(PlayerArmorChangeEvent.class, ItemType.class, (Getter)new Getter<ItemType, PlayerArmorChangeEvent>(){

                public ItemType get(PlayerArmorChangeEvent e) {
                    ItemStack item = e.getOldItem();
                    if (item != null) {
                        return new ItemType(item);
                    }
                    return null;
                }
            }, (int)-1);
            EventValues.registerEventValue(PlayerArmorChangeEvent.class, ItemType.class, (Getter)new Getter<ItemType, PlayerArmorChangeEvent>(){

                public ItemType get(PlayerArmorChangeEvent e) {
                    ItemStack item = e.getNewItem();
                    if (item != null) {
                        return new ItemType(item);
                    }
                    return null;
                }
            }, (int)0);
            EventValues.registerEventValue(PlayerArmorChangeEvent.class, ItemType.class, (Getter)new Getter<ItemType, PlayerArmorChangeEvent>(){

                public ItemType get(PlayerArmorChangeEvent e) {
                    ItemStack item = e.getNewItem();
                    if (item != null) {
                        return new ItemType(item);
                    }
                    return null;
                }
            }, (int)1);
            Skript.registerEvent((String)"Player Pickup Experience Orb", SimpleEvent.class, PlayerPickupExperienceEvent.class, (String[])new String[]{"player pickup (experience|xp) [orb]"}).description(new String[]{"Fired when a player is attempting to pick up an experience orb"}).examples(new String[]{"on player pickup xp:", "\tadd 10 to level of player"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Player Ready Arrow", SimpleEvent.class, PlayerReadyArrowEvent.class, (String[])new String[]{"player ready arrow"}).description(new String[]{"Called when a player is firing a bow and the server is choosing an arrow to use."}).examples(new String[]{"ToDo"}).requiredPlugins(new String[]{"Paper 1.12.2+"}).since("1.0.0");
            EventValues.registerEventValue(PlayerReadyArrowEvent.class, ItemType.class, (Getter)new Getter<ItemType, PlayerReadyArrowEvent>(){

                public ItemType get(PlayerReadyArrowEvent e) {
                    return new ItemType(e.getArrow());
                }
            }, (int)0);
        }
        if (Skript.isRunningMinecraft((int)1, (int)13, (int)2)) {
            Skript.registerEvent((String)"Anvil Damage", SimpleEvent.class, AnvilDamagedEvent.class, (String[])new String[]{"anvil damag(e|ing)"}).description(new String[]{"Called when an anvil is damaged from being used"}).examples(new String[]{"on anvil damage:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"TNT Primed", SimpleEvent.class, TNTPrimeEvent.class, (String[])new String[]{"tnt prime[d]"}).description(new String[]{"Called when TNT block is about to turn into TNTPrimed"}).examples(new String[]{"on tnt prime:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Creeper Ignite", SimpleEvent.class, CreeperIgniteEvent.class, (String[])new String[]{"creeper ignit(e|ing)"}).description(new String[]{"Called when a Creeper is ignite flag is changed (armed/disarmed to explode)"}).examples(new String[]{"on creeper ignite:", "\tspawn 2 creeper at event-location"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Enderdragon Shoot Fireball", SimpleEvent.class, EnderDragonShootFireballEvent.class, (String[])new String[]{"ender[ ]dragon shoot[s] fireball"}).description(new String[]{"Fired when an EnderDragon shoots a fireball"}).examples(new String[]{""}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Enderdragon Fireball Hit", SimpleEvent.class, EnderDragonFireballHitEvent.class, (String[])new String[]{"ender[ ]dragon fireball hit"}).description(new String[]{"Fired when a DragonFireball collides with a block/entity and spawns an AreaEffectCloud"}).examples(new String[]{"on enderdragon fireball hit:", "\tloop all players in radius 5 of event-location:", "\t\theal loop-player by 2 hearts"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Skeleton Horse Trap", SimpleEvent.class, SkeletonHorseTrapEvent.class, (String[])new String[]{"skeleton horse trap"}).description(new String[]{"Event called when a player gets close to a <a href='https://minecraft.gamepedia.com/Horse#Skeleton_trap'>skeleton horse trap</a> and triggers the lightning trap."}).examples(new String[]{"on skeleton horse trap:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Turtle Go Home", SimpleEvent.class, TurtleGoHomeEvent.class, (String[])new String[]{"turtle go home"}).description(new String[]{"Fired when a Turtle decides to go home"}).examples(new String[]{"ToDo"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Turtle Lay Egg", SimpleEvent.class, TurtleLayEggEvent.class, (String[])new String[]{"turtle lay[s] egg"}).description(new String[]{"Fired when a Turtle lays eggs"}).examples(new String[]{"on turtle lay egg:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Turtle Starts Digging", SimpleEvent.class, TurtleStartDiggingEvent.class, (String[])new String[]{"turtle start[s] digging"}).description(new String[]{"Fired when a Turtle starts digging to lay eggs"}).examples(new String[]{"on turtle starts digging:", "\tcancel event"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
            Skript.registerEvent((String)"Player Elytra Boost", SimpleEvent.class, PlayerElytraBoostEvent.class, (String[])new String[]{"[player] elytra boost"}).description(new String[]{"Fired when a player boosts elytra flight with a firework"}).examples(new String[]{"on elytra boost:", "\tpush player forward at speed 50"}).requiredPlugins(new String[]{"Paper 1.13.2+"}).since("1.0.0");
        }
    }
}

