/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

@Name(value="Entity Origin")
@Description(value={"The location where an entity originates from (Based on testing, entities spawned during chunk generation do not have an origin)"})
@Examples(value={"loop all entities in radius 10 around player:", "\tif loop-entity is not a player:", "\t\tteleport loop-entity to origin of loop-entity"})
@RequiredPlugins(value={"Paper 1.13.2+"})
@Since(value="1.1.0")
public class ExprEntityOrigin
extends SimplePropertyExpression<Entity, Location> {
    @Nullable
    public Location convert(Entity t) {
        return t.getOrigin();
    }

    protected String getPropertyName() {
        return "entity origin";
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13, (int)2)) {
            ExprEntityOrigin.register(ExprEntityOrigin.class, Location.class, (String)"origin[al] [location]", (String)"entity");
        }
    }
}

