/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Turtle;
import org.bukkit.event.Event;

@Name(value="Turtle Home")
@Description(value={"The home of a turtle"})
@Examples(value={""})
@RequiredPlugins(value={"Paper 1.13.2+"})
@Since(value="1.1.0")
public class ExprTurtleHome
extends SimplePropertyExpression<LivingEntity, Location> {
    @Nullable
    public Location convert(LivingEntity t) {
        if (t instanceof Turtle) {
            return ((Turtle)t).getHome();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Location.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            for (LivingEntity t : (LivingEntity[])this.getExpr().getArray(e)) {
                if (!(t instanceof Turtle)) {
                    return;
                }
                ((Turtle)t).setHome(null);
            }
        } else {
            Location l = (Location)delta[0];
            for (LivingEntity t : (LivingEntity[])this.getExpr().getArray(e)) {
                if (!(t instanceof Turtle)) {
                    return;
                }
                ((Turtle)t).setHome(l);
            }
        }
    }

    protected String getPropertyName() {
        return "turtle home";
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13, (int)2)) {
            ExprTurtleHome.register(ExprTurtleHome.class, Location.class, (String)"home[s] [location[s]]", (String)"livingentity");
        }
    }
}

