/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import java.lang.reflect.Array;
import java.util.regex.MatchResult;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Projectile Collision Target")
@Description(value={"The entity that is hit in a projectile collide event"})
@Examples(value={"on projectile collide:", "\tif projectile target is a sheep:", "\t\tcancel event"})
@Events(value={"projectile collide"})
@RequiredPlugins(value={"Paper 1.11.2+"})
@Since(value="1.1.0")
public class ExprProjectileTarget
extends SimpleExpression<Entity> {
    private EntityData<?> type;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String type;
        if (!ScriptLoader.isCurrentEvent(ProjectileCollideEvent.class)) {
            Skript.error((String)"The expression 'projectile target' can only be used in a projectile collide event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        String string = type = parser.regexes.size() == 0 ? null : ((MatchResult)parser.regexes.get(0)).group();
        if (type == null) {
            this.type = EntityData.fromClass(Entity.class);
        } else {
            EntityData t = EntityData.parse((String)type);
            if (t == null) {
                Skript.error((String)("'" + type + "' is not an entity type"), (ErrorQuality)ErrorQuality.NOT_AN_EXPRESSION);
                return false;
            }
            this.type = t;
        }
        return true;
    }

    @Nullable
    protected Entity[] get(Event e) {
        Entity[] one = (Entity[])Array.newInstance(this.type.getType(), 1);
        Entity entity = ((ProjectileCollideEvent)e).getCollidedWith();
        if (this.type.isInstance(entity)) {
            one[0] = entity;
            return one;
        }
        return null;
    }

    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the attacked " + this.type;
        }
        return Classes.getDebugMessage((Object)this.getSingle(e));
    }

    public boolean isSingle() {
        return true;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)11, (int)2)) {
            Skript.registerExpression(ExprProjectileTarget.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] projectile target [<(.+)>]"});
        }
    }
}

