/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skriptpaper.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Turtle;

@Name(value="Has Egg")
@Description(value={"Checks if a turtle has an egg"})
@Examples(value={"loop all turtles in radius 10 around player:", "\tif loop-turtle has an egg:", "\tspawn 1 baby turtle at location of loop-turtle"})
@RequiredPlugins(value={"Paper 1.13.2+"})
@Since(value="1.1.0")
public class CondTurtleHasEgg
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity t) {
        if (t instanceof Turtle) {
            return ((Turtle)t).hasEgg();
        }
        return false;
    }

    protected PropertyCondition.PropertyType getPropertyType() {
        return PropertyCondition.PropertyType.HAVE;
    }

    protected String getPropertyName() {
        return "has egg";
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13, (int)2)) {
            CondTurtleHasEgg.register(CondTurtleHasEgg.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"[an] egg[s]", (String)"livingentitiies");
        }
    }
}

