/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Name(value="Inner/outer html of element")
@Description(value={"Get the inner or outer html of a htmlelement as a htmldocument."})
@Examples(value={"set {_inner} to inner html of element {_element}", "set {_outer} to outer html of element {_element}"})
@Since(value="1.2")
public class ExprElementHtml
extends SimpleExpression<Document> {
    private Expression<Element> expr_elm;
    private Integer ParseMark;

    protected Document[] get(Event event) {
        switch (this.ParseMark) {
            case 0: {
                return new Document[]{Jsoup.parse(((Element)this.expr_elm.getSingle(event)).html())};
            }
            case 1: {
                return new Document[]{Jsoup.parse(((Element)this.expr_elm.getSingle(event)).outerHtml())};
            }
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Document> getReturnType() {
        return Document.class;
    }

    public String toString(Event event, boolean b) {
        return "inner or outer html of an element";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_elm = expressions[0];
        this.ParseMark = parseResult.mark;
        return true;
    }

    static {
        Skript.registerExpression(ExprElementHtml.class, Document.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(0\u00a6inner|1\u00a6outer) html (of|from) [element] %htmlelement%"});
    }
}

