/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jsoup.nodes.Element;

@Name(value="Tag name of element")
@Description(value={"Get the tag name of an element."})
@Examples(value={"set {_tag} to html tag of element {_element}"})
@Since(value="1.0-BETA")
public class ExprElementTagName
extends SimpleExpression<String> {
    private Expression<Element> expr_elm;

    protected String[] get(Event event) {
        if (this.expr_elm == null) {
            return null;
        }
        return new String[]{((Element)this.expr_elm.getSingle(event)).tagName()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "tag name of an element";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_elm = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprElementTagName.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [html] tag [name] of %htmlelement%"});
    }
}

