/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jsoup.nodes.Element;

@Name(value="Attribute of element")
@Description(value={"Get the specified attribute of an element."})
@Examples(value={"set {_attribute} to attribute \"abs:href\" of element {_element}"})
@Since(value="1.0-BETA")
public class ExprElementAttribute
extends SimpleExpression<String> {
    private Expression<String> expr_str;
    private Expression<Element> expr_elm;

    protected String[] get(Event event) {
        if (this.expr_elm == null || this.expr_str == null) {
            return null;
        }
        return new String[]{((Element)this.expr_elm.getSingle(event)).attr((String)this.expr_str.getSingle(event))};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "attribute " + (String)this.expr_str.getSingle(event) + " of an element";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_str = expressions[0];
        this.expr_elm = expressions[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprElementAttribute.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] attribute %string% of [[html] element] %htmlelement%"});
    }
}

