/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jsoup.nodes.Document;

@Name(value="Title of document")
@Description(value={"Get the html title of a document."})
@Examples(value={"set {_title} to html title of document {_document}"})
@Since(value="1.2")
public class ExprDocumentTitle
extends SimpleExpression<String> {
    private Expression<Document> expr_doc;

    protected String[] get(Event event) {
        if (this.expr_doc == null) {
            return null;
        }
        return new String[]{((Document)this.expr_doc.getSingle(event)).title()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "title of a document";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_doc = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprDocumentTitle.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[html] title (of|from) %htmldocument%"});
    }
}

