/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Name(value="Head of document")
@Description(value={"Get the html head of a document as an element."})
@Examples(value={"set {_head} to html head of document {_document}"})
@Since(value="1.2")
public class ExprDocumentHead
extends SimpleExpression<Element> {
    private Expression<Document> expr_doc;

    protected Element[] get(Event event) {
        if (this.expr_doc == null) {
            return null;
        }
        return new Element[]{((Document)this.expr_doc.getSingle(event)).head()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Element> getReturnType() {
        return Element.class;
    }

    public String toString(Event event, boolean b) {
        return "html head of a document";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_doc = expressions[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprDocumentHead.class, Element.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[html] head (of|from) [document] %htmldocument%"});
    }
}

