/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.event.Event;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Name(value="Request document")
@Description(value={"Request a html document from a website with optional user agent, timeout and referer."})
@Examples(value={"request document from {_url} with user agent {_agent} and timeout {_timeout} and referrer {_referer}"})
@Since(value="1.0-BETA")
public class EffRequestDocument
extends Effect {
    static Document lastHtmlDocument;
    private static final ExecutorService fixedThreadPool;
    private Expression<String> expr_url;
    private Expression<String> expr_agent;
    private Expression<Integer> expr_timeout;
    private Expression<String> expr_referer;

    protected void execute(Event event) {
        CompletableFuture<Document> request = CompletableFuture.supplyAsync(() -> this.sendRequest(event), fixedThreadPool);
        request.whenComplete((resp, err) -> {
            if (err != null) {
                err.printStackTrace();
            }
            if (resp != null) {
                lastHtmlDocument = resp;
            }
            if (this.getNext() != null) {
                TriggerItem.walk((TriggerItem)this.getNext(), (Event)event);
            }
        });
    }

    public String toString(Event event, boolean b) {
        return "send html document request";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_url = expressions[0];
        this.expr_agent = expressions[1];
        this.expr_timeout = expressions[2];
        this.expr_referer = expressions[3];
        return true;
    }

    private Document sendRequest(Event e) {
        String url = (String)this.expr_url.getSingle(e);
        String agent = (String)this.expr_agent.getSingle(e);
        Integer timeout = (Integer)this.expr_timeout.getSingle(e);
        String referer = (String)this.expr_referer.getSingle(e);
        if (url == null) {
            return null;
        }
        Connection conn = Jsoup.connect(url);
        try {
            if (agent != null && timeout != null && referer != null) {
                return conn.userAgent(agent).timeout(timeout).referrer(referer).get();
            }
            return conn.get();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        this.execute(e);
        return null;
    }

    static {
        Skript.registerEffect(EffRequestDocument.class, (String[])new String[]{"request [html] doc[ument] (of|from) [url] %string% [(with|using) user agent %-string% [and] timeout %-integer% [and] refer[r]er %-string%]"});
        fixedThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}

