/*
 * Decompiled with CFR 0.152.
 */
package io.github.nanodankster.skraper.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Name(value="Elements from document")
@Description(value={"Get the specified elements of a document."})
@Examples(value={"set {_elements::*} to elements \"a[href]\" of document {_document}"})
@Since(value="1.0-BETA")
public class ExprDocumentElements
extends SimpleExpression<Element> {
    private Expression<String> expr_str;
    private Expression<Document> expr_doc;

    protected Element[] get(Event event) {
        if (this.expr_doc.getSingle(event) != null) {
            Elements elms = ((Document)this.expr_doc.getSingle(event)).select((String)this.expr_str.getSingle(event));
            Element[] ret = new Element[elms.size()];
            int i = 0;
            Iterator iterator = elms.iterator();
            while (iterator.hasNext()) {
                Element e;
                ret[i] = e = (Element)iterator.next();
                ++i;
            }
            return ret;
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Element> getReturnType() {
        return Element.class;
    }

    public String toString(Event event, boolean b) {
        return "elements " + (String)this.expr_str.getSingle(event) + " of a document";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expr_str = expressions[0];
        this.expr_doc = expressions[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprDocumentElements.class, Element.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] element[s] %string% (of|from) [[html] doc[ument]] %htmldocument%"});
    }
}

