/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore.utils;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.limeglass.skore.Skore;
import me.limeglass.skore.utils.LangEnumParser;
import org.eclipse.jdt.annotation.Nullable;

public class EnumClassInfo<E extends Enum<E>> {
    private final Class<E> enumType;
    private final ClassInfo<E> classInfo;
    private final String codeName;
    private final String user;
    private final HashMap<String, String> synonyms = new HashMap();

    private EnumClassInfo(Class<E> enumType, String codeName, @Nullable String user) {
        this.enumType = enumType;
        this.codeName = codeName;
        this.user = user;
        this.classInfo = new ClassInfo(enumType, codeName);
    }

    public static <E extends Enum<E>> EnumClassInfo<E> create(Class<E> enumType, String codeName, @Nullable String user) {
        if (user == null) {
            user = codeName + "s?";
        }
        return new EnumClassInfo<E>(enumType, codeName, user);
    }

    public EnumClassInfo<E> addSynonym(String regex, String actualValue) {
        this.synonyms.put(regex, actualValue);
        return this;
    }

    public EnumClassInfo<E> after(String ... after) {
        this.classInfo.after(after);
        return this;
    }

    public EnumClassInfo<E> before(String ... before) {
        this.classInfo.before(before);
        return this;
    }

    public void register() {
        if (Classes.getExactClassInfo(this.enumType) == null) {
            if (Skore.getInstance().getConfig().getBoolean("UseEnglishEnums")) {
                Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{this.user}).parser(new LangEnumParser<E>(this.codeName, this.enumType)).serializer((Serializer)new EnumSerializer(this.enumType)));
            } else {
                Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{this.user}).parser(new Parser<E>(){

                    public E parse(String s, ParseContext parseContext) {
                        if (s.startsWith(EnumClassInfo.this.codeName + ":")) {
                            s = s.substring(EnumClassInfo.this.codeName.length() + 1, s.length());
                        }
                        try {
                            for (Map.Entry p : EnumClassInfo.this.synonyms.entrySet()) {
                                if (!s.matches((String)p.getKey())) continue;
                                return Enum.valueOf(EnumClassInfo.this.enumType, (String)p.getValue());
                            }
                            return Enum.valueOf(EnumClassInfo.this.enumType, s.replace(" ", "_").toLowerCase().trim());
                        }
                        catch (IllegalArgumentException e) {
                            return null;
                        }
                    }

                    public String toString(E e, int i) {
                        return ((Enum)e).toString();
                    }

                    public String toVariableNameString(E e) {
                        return EnumClassInfo.this.codeName + ':' + ((Enum)e).toString();
                    }

                    public String getVariableNamePattern() {
                        return EnumClassInfo.this.codeName + ":.+";
                    }
                }).serializer((Serializer)new EnumSerializer(this.enumType)));
                ArrayList<String> enums = new ArrayList<String>();
                for (Enum e : (Enum[])this.enumType.getEnumConstants()) {
                    enums.add(e.name());
                }
                Skore.getInstance().getConfiguration("syntax").set("Syntax.Enums." + this.enumType.getSimpleName() + ".enums", enums);
            }
            this.enumDebug("&5Registered Enum '" + this.codeName + "' with return class " + this.enumType.getName(), this.codeName, this.enumType);
        }
    }

    private void enumDebug(String message, String codeName, Class<?> clazz) {
        if (codeName.equalsIgnoreCase(Skore.getInstance().getConfig().getString("syntaxDebug"))) {
            Skore.debugMessage("&eRegistered syntaxDebug found enum classinfo: " + codeName + " (" + clazz.getCanonicalName() + ")");
        } else {
            Skore.debugMessage("&5Registered Enum '" + codeName + "' with return class " + this.enumType.getName());
        }
        Skore.getInstance().getConfiguration("syntax").set("Syntax.Enums." + clazz.getSimpleName() + ".user", (Object)this.user);
        Skore.save("syntax");
    }
}

