/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import io.puharesource.mc.titlemanager.api.v2.TitleManagerAPI;
import me.limeglass.skore.Skore;
import me.limeglass.skore.lang.SkorePropertyExpression;
import me.limeglass.skore.utils.annotations.Changers;
import me.limeglass.skore.utils.annotations.Properties;
import me.limeglass.skore.utils.annotations.PropertiesAddition;
import me.limeglass.skore.utils.annotations.Settable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Skoreboard - Title")
@Description(value={"Returns or changes the title of the Skoreboard(s)."})
@Properties(value={"players", "title[s]", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="skoreboard[s]")
@Changers(value={Changer.ChangeMode.SET, Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET})
@Settable(value={String.class})
public class ExprTitle
extends SkorePropertyExpression<Player, String> {
    private TitleManagerAPI api = Skore.getTitleManagerAPI();

    protected String[] get(Event event, Player[] players) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        for (Player player : players) {
            this.collection.add(this.api.getScoreboardTitle(player));
        }
        return this.collection.toArray(new String[this.collection.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        for (Player player : this.expressions.getAll(event, Player.class)) {
            if (mode == Changer.ChangeMode.SET) {
                this.api.setProcessedScoreboardTitle(player, (String)delta[0]);
                continue;
            }
            this.api.setProcessedScoreboardTitle(player, player.getDisplayName());
        }
    }
}

