/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore;

import ch.njol.skript.doc.Description;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.util.SimpleEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.limeglass.skore.Skore;
import me.limeglass.skore.utils.Utils;
import me.limeglass.skore.utils.annotations.AllChangers;
import me.limeglass.skore.utils.annotations.Changers;
import me.limeglass.skore.utils.annotations.Disabled;

public class Syntax {
    private static HashMap<String, String[]> modified = new HashMap();
    private static HashMap<String, String[]> completeSyntax = new HashMap();

    public static String[] register(Class<?> syntaxClass, String ... syntax) {
        if (syntaxClass.isAnnotationPresent(Disabled.class)) {
            return null;
        }
        String type = "Expressions";
        if (Condition.class.isAssignableFrom(syntaxClass)) {
            type = "Conditions";
        } else if (Effect.class.isAssignableFrom(syntaxClass)) {
            type = "Effects";
        } else if (SimpleEvent.class.isAssignableFrom(syntaxClass)) {
            type = "Events";
        } else if (PropertyExpression.class.isAssignableFrom(syntaxClass)) {
            type = "PropertyExpressions";
        }
        String node = "Syntax." + type + "." + syntaxClass.getSimpleName() + ".";
        if (!Skore.getInstance().getConfiguration("syntax").isSet(node + "enabled")) {
            Skore.getInstance().getConfiguration("syntax").set(node + "enabled", (Object)true);
            Skore.save("syntax");
        }
        if (syntaxClass.isAnnotationPresent(Changers.class) || syntaxClass.isAnnotationPresent(AllChangers.class)) {
            if (syntaxClass.isAnnotationPresent(AllChangers.class)) {
                Skore.getInstance().getConfiguration("syntax").set(node + "changers", (Object)"All changers");
            } else {
                Object[] changers = syntaxClass.getAnnotation(Changers.class).value();
                Skore.getInstance().getConfiguration("syntax").set(node + "changers", (Object)Arrays.toString(changers));
            }
            Skore.save("syntax");
        }
        if (syntaxClass.isAnnotationPresent(Description.class)) {
            String[] descriptions = syntaxClass.getAnnotation(Description.class).value();
            Skore.getInstance().getConfiguration("syntax").set(node + "description", (Object)descriptions[0]);
            Skore.save("syntax");
        }
        if (!Skore.getInstance().getConfiguration("syntax").getBoolean(node + "enabled")) {
            if (Skore.getInstance().getConfig().getBoolean("NotRegisteredSyntax", false)) {
                Skore.consoleMessage(node.toString() + " didn't register!");
            }
            return null;
        }
        if (!Skore.getInstance().getConfiguration("syntax").isSet(node + "syntax")) {
            Skore.getInstance().getConfiguration("syntax").set(node + "syntax", (Object)syntax);
            Skore.save("syntax");
            return Syntax.add(syntaxClass.getSimpleName(), syntax);
        }
        List data = Skore.getInstance().getConfiguration("syntax").getStringList(node + "syntax");
        if (!Utils.compareArrays(data.toArray(new String[data.size()]), syntax)) {
            modified.put(syntaxClass.getSimpleName(), syntax);
        }
        if (Skore.getInstance().getConfiguration("syntax").isList(node + "syntax")) {
            List syntaxes = Skore.getInstance().getConfiguration("syntax").getStringList(node + "syntax");
            return Syntax.add(syntaxClass.getSimpleName(), syntaxes.toArray(new String[syntaxes.size()]));
        }
        return Syntax.add(syntaxClass.getSimpleName(), Skore.getInstance().getConfiguration("syntax").getString(node + "syntax"));
    }

    public static Boolean isModified(Class syntaxClass) {
        return modified.containsKey(syntaxClass.getSimpleName());
    }

    public static String[] get(String syntaxClass) {
        return completeSyntax.get(syntaxClass);
    }

    private static String[] add(String syntaxClass, String ... syntax) {
        if (!completeSyntax.containsValue(syntax)) {
            completeSyntax.put(syntaxClass, syntax);
        }
        return syntax;
    }
}

