/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.limeglass.skore.Skore;
import me.limeglass.skore.utils.ReflectionUtil;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Events {
    public static void registerEvent(@Nullable Class<? extends SkriptEvent> skriptEvent, Class<? extends Event> event, String ... patterns) {
        if (!Skore.getInstance().getConfig().getBoolean("Events", true)) {
            return;
        }
        if (skriptEvent == null) {
            skriptEvent = SimpleEvent.class;
        }
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = Skore.getNameplate() + patterns[i];
        }
        Object[] values = new Object[]{true, patterns, Events.getEventValues(event)};
        String[] nodes = new String[]{"enabled", "patterns", "eventvalues"};
        for (int i = 0; i < nodes.length; ++i) {
            if (Skore.getInstance().getConfiguration("syntax").isSet("Syntax.Events." + event.getSimpleName() + "." + nodes[i])) continue;
            Skore.getInstance().getConfiguration("syntax").set("Syntax.Events." + event.getSimpleName() + "." + nodes[i], values[i]);
        }
        Skore.save("syntax");
        if (Skore.getInstance().getConfiguration("syntax").getBoolean("Syntax.Events." + event.getSimpleName() + ".enabled", true)) {
            Skript.registerEvent((String)("Skore " + event.getSimpleName()), skriptEvent, event, (String[])patterns);
            Skore.debugMessage("&5Registered Event " + event.getSimpleName() + " (" + skriptEvent.getCanonicalName() + ") with syntax " + Arrays.toString(patterns));
        }
    }

    @SafeVarargs
    private static final List<String> getEventValues(Class<? extends Event> ... events) {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            Method method = EventValues.class.getDeclaredMethod("getEventValuesList", Integer.TYPE);
            method.setAccessible(true);
            for (Class<? extends Event> event : events) {
                for (int i = -1; i < 2; ++i) {
                    List eventValueInfos = (List)method.invoke(EventValues.class, i);
                    if (eventValueInfos == null) continue;
                    for (Object eventValueInfo : eventValueInfos) {
                        Class clazz;
                        Class e = (Class)ReflectionUtil.getField("event", eventValueInfo.getClass(), eventValueInfo);
                        if (e == null || !e.isAssignableFrom(event) && !event.isAssignableFrom(e) || (clazz = (Class)ReflectionUtil.getField("c", eventValueInfo.getClass(), eventValueInfo)) == null) continue;
                        classes.add(clazz.getSimpleName());
                    }
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
            error.printStackTrace();
        }
        return classes;
    }
}

