/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import io.puharesource.mc.titlemanager.api.v2.TitleManagerAPI;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.limeglass.skore.Metrics;
import me.limeglass.skore.SpigotConfigSaver;
import me.limeglass.skore.elements.Register;
import me.limeglass.skore.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Skore
extends JavaPlugin {
    private static Map<String, FileConfiguration> files = new HashMap<String, FileConfiguration>();
    private String packageName = "me.limeglass.skore";
    private static String prefix = "&8[&6Skore&8] &e";
    private static String nameplate = "[Skore] ";
    private static TitleManagerAPI api;
    private static Skore instance;
    private SkriptAddon addon;
    private Metrics metrics;

    public void onEnable() {
        this.addon = Skript.registerAddon((JavaPlugin)this);
        instance = this;
        this.saveDefaultConfig();
        File config = new File(this.getDataFolder(), "config.yml");
        if (!Objects.equals(this.getDescription().getVersion(), this.getConfig().getString("version"))) {
            Skore.consoleMessage("&dNew update found! Updating files now...");
            if (config.exists()) {
                new SpigotConfigSaver(this).execute();
            }
        }
        for (String name : Arrays.asList("config", "syntax")) {
            File file = new File(this.getDataFolder(), name + ".yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                this.saveResource(file.getName(), false);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            files.put(name, (FileConfiguration)configuration);
        }
        api = (TitleManagerAPI)Bukkit.getServer().getPluginManager().getPlugin("TitleManager");
        this.metrics = new Metrics(this);
        Register.metrics(this.metrics);
        if (!this.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(nameplate + "has been enabled!");
        }
    }

    public static TitleManagerAPI getTitleManagerAPI() {
        return api;
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static Skore getInstance() {
        return instance;
    }

    public static String getPrefix() {
        return prefix;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public FileConfiguration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static void save(String configuration) {
        try {
            File configurationFile = new File(instance.getDataFolder(), configuration + ".yml");
            instance.getConfiguration(configuration).save(configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void debugMessage(String ... messages) {
        if (instance.getConfig().getBoolean("debug")) {
            for (String text : messages) {
                Skore.consoleMessage("&b" + text);
            }
        }
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                Bukkit.getLogger().info(Skore.getNameplate() + text);
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (instance.getConfig().getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                if (instance.getConfig().getBoolean("DisableConsoleColour", false)) {
                    Skore.infoMessage(ChatColor.stripColor((String)Utils.cc(text)));
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage(Utils.cc(prefix + text));
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }
}

