/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skore.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import io.puharesource.mc.titlemanager.APIProvider;
import io.puharesource.mc.titlemanager.api.v2.TitleManagerAPI;
import me.limeglass.skore.lang.SkorePropertyExpression;
import me.limeglass.skore.utils.annotations.Changers;
import me.limeglass.skore.utils.annotations.Properties;
import me.limeglass.skore.utils.annotations.PropertiesAddition;
import me.limeglass.skore.utils.annotations.Settable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Skoreboard - Value")
@Description(value={"Returns or changes the value of the Skoreboard(s)."})
@Properties(value={"players", "(slot|value|line)[s] %numbers%", "{1}[(all [[of] the]|the)]"})
@PropertiesAddition(value="skoreboard[s]")
@Changers(value={Changer.ChangeMode.SET, Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET})
@Settable(value={String.class})
public class ExprValue
extends SkorePropertyExpression<Player, String> {
    private TitleManagerAPI api = APIProvider.INSTANCE;

    protected String[] get(Event event, Player[] players) {
        if (this.isNull(event).booleanValue()) {
            return null;
        }
        for (Player player : players) {
            for (Number slot : this.expressions.getAll(event, Number.class)) {
                this.collection.add(this.api.getScoreboardValue(player, slot.intValue()));
            }
        }
        return this.collection.toArray(new String[this.collection.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (this.isNull(event).booleanValue() || delta == null) {
            return;
        }
        for (Player player : this.expressions.getAll(event, Player.class)) {
            for (Number slot : this.expressions.getAll(event, Number.class)) {
                if (mode == Changer.ChangeMode.SET) {
                    this.api.setScoreboardValueWithPlaceholders(player, slot.intValue(), (String)delta[0]);
                    continue;
                }
                this.api.removeScoreboardValue(player, slot.intValue());
            }
        }
    }
}

