/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.scopes;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.testing.Testing;
import com.olyno.skester.testing.TestingAssert;
import com.olyno.skester.util.scope.EffectSection;
import com.vdurmont.emoji.EmojiParser;
import java.util.HashMap;
import java.util.LinkedList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

@Name(value="Scope Test")
@Description(value={"Create a test. The string is the name of the test."})
@Examples(value={"command checkNull:\n\ttrigger:\n\t\tit \"should be null\":\n\t\t\tbroadcast \"Awesome!\""})
@Since(value="1.0.0")
public class ScopeTest
extends EffectSection {
    public static Testing latestTest;
    public static LinkedList<Testing> tests;
    private HashMap<ChatColor, String> emojis = new HashMap();
    private Expression<String> testName;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (!this.hasSection()) {
            return false;
        }
        this.testName = expr[0];
        this.emojis.put(ChatColor.RED, ":x:");
        this.emojis.put(ChatColor.GREEN, ":white_check_mark:");
        this.loadSection(true);
        return true;
    }

    @Override
    protected void execute(Event e) {
        latestTest = new Testing((String)this.testName.getSingle(e));
        latestTest.setTestId(tests.size());
        tests.add(latestTest);
        this.runSection(e);
        for (Testing test : tests) {
            ChatColor resultColor = test.isFailed() != false ? ChatColor.RED : ChatColor.GREEN;
            Bukkit.getConsoleSender().sendMessage(EmojiParser.parseToUnicode(resultColor + this.repeat("\t", test.getTestId()) + (test.getTestId() > 0 ? "|- " : "") + this.emojis.get(resultColor) + " " + test.getTestName()));
            for (TestingAssert testingAssert : test.getAsserts()) {
                if (testingAssert.isFailed().booleanValue()) {
                    Bukkit.getConsoleSender().sendMessage(EmojiParser.parseToUnicode(ChatColor.RED + this.repeat("\t", test.getTestId() + 1) + "|- :x: " + (testingAssert.getMessage() != null ? testingAssert.getMessage() : "<Testing>")));
                    Bukkit.getConsoleSender().sendMessage(EmojiParser.parseToUnicode(ChatColor.RED + this.repeat("\t", test.getTestId() + 2) + "==> Excepted \"" + testingAssert.getOutput() + "\", got \"" + testingAssert.getInput() + "\""));
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage(EmojiParser.parseToUnicode(ChatColor.GREEN + this.repeat("\t", test.getTestId() + 1) + "|- :white_check_mark: " + testingAssert.getMessage()));
            }
        }
        tests.clear();
    }

    private String repeat(String value, int amount) {
        return new String(new char[amount]).replace("\u0000", value);
    }

    public String toString(Event e, boolean debug) {
        return "it " + this.testName.toString(e, debug);
    }

    static {
        Skript.registerCondition(ScopeTest.class, (String[])new String[]{"it %string%"});
        tests = new LinkedList();
    }
}

