/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.util.effects.AssertEffect;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

@Name(value="Fail Test")
@Description(value={"Makes the test fail if a condition is respected (or just force to fail the test)."})
@Examples(value={"command failTest:\n\ttrigger:\n\t\tit \"should be failed\":\n\t\t\tfail test"})
@Since(value="1.0.0")
public class EffFailTest
extends AssertEffect {
    private String condition;
    private Expression<String> message;
    private Boolean forceFail;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.message = expr[0];
        this.forceFail = matchedPattern == 0;
        this.condition = this.forceFail != false ? null : ((MatchResult)parseResult.regexes.get(0)).group();
        return true;
    }

    protected void execute(Event e) {
        if (this.isAvailable().booleanValue()) {
            String msg;
            String string = msg = this.message != null ? (String)this.message.getSingle(e) : "";
            if (this.forceFail.booleanValue() || this.condition != null && Condition.parse((String)this.condition, (String)("Can't understand this condition: " + this.condition)).check(e)) {
                if (msg.isEmpty()) {
                    this.latestTest.fail();
                } else {
                    this.latestTest.fail(msg);
                }
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "fail test " + (this.forceFail != false ? "" : this.condition) + (this.message != null ? " with message " + this.message.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffFailTest.class, (String[])new String[]{"fail [the] test [with [[error] message] %-string%]", "fail [the] test [if] <.+> [with [[error] message] %-string%]"});
    }
}

