/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.util.effects.AssertEffect;
import org.bukkit.event.Event;

@Name(value="Assert Null")
@Description(value={"Checks if a value is null. Throw an error if it is not."})
@Examples(value={"command checkNull:\n\ttrigger:\n\t\tit \"should be null\":\n\t\t\tassert null {_test} with message \"This variable is null!\""})
@Since(value="1.0.0")
public class EffAssertNull
extends AssertEffect {
    private Expression<Object> value;
    private Expression<String> message;
    private boolean isNegated;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.value = expr[0];
        this.message = expr[1];
        this.isNegated = matchedPattern == 1;
        return true;
    }

    protected void execute(Event e) {
        if (this.isAvailable().booleanValue()) {
            String msg;
            String string = msg = this.message != null ? (String)this.message.getSingle(e) : "";
            if (this.isNegated) {
                if (!msg.isEmpty()) {
                    this.latestTest.assertNotNull(this.value.getSingle(e), msg);
                } else {
                    this.latestTest.assertNotNull(this.value.getSingle(e));
                }
            } else if (!msg.isEmpty()) {
                this.latestTest.assertNull(this.value.getSingle(e), msg);
            } else {
                this.latestTest.assertNull(this.value.getSingle(e));
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "assert" + (this.isNegated ? " not" : "") + " null " + this.value.toString(e, debug) + (this.message != null ? " with message " + this.message.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffAssertNull.class, (String[])new String[]{"assert [is] null %object% [with [[error] message] %-string%]", "assert [is] not null %object% [with [message] %-string%]"});
    }
}

