/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.util.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import com.olyno.skester.Skester;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class AsyncEffect
extends Effect {
    private static boolean CAN_MANAGE_LOCAL_VARS = Skript.methodExists(Variables.class, (String)"removeLocals", (Class[])new Class[]{Event.class}) && Skript.methodExists(Variables.class, (String)"setLocalVariables", (Class[])new Class[]{Event.class, Object.class});
    private Object localVars;

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        Delay.addDelayedEvent((Event)e);
        this.execute(e);
        return null;
    }

    protected void executeCode(Event e, Runnable asyncCode) {
        this.executeCode(e, asyncCode, () -> {});
    }

    protected void executeCode(Event e, Runnable asyncCode, Runnable syncCode) {
        this.removeAndSaveLocals(e);
        CompletableFuture.supplyAsync(() -> {
            asyncCode.run();
            return true;
        }).whenComplete((result, ex) -> Bukkit.getScheduler().runTask((Plugin)Skester.instance, () -> {
            if (ex != null) {
                this.putLocalsBackAndContinueTrigger(e);
                Skript.exception((Throwable)ex, (String[])new String[0]);
                return;
            }
            if (!result.booleanValue()) {
                this.putLocalsBackAndContinueTrigger(e);
                return;
            }
            syncCode.run();
            if (this.shouldContinue()) {
                this.putLocalsBack(e);
                this.continueTriggerAndRemoveLocals(e);
            }
        }));
    }

    protected void removeAndSaveLocals(Event e) {
        if (CAN_MANAGE_LOCAL_VARS) {
            this.localVars = Variables.removeLocals((Event)e);
        }
    }

    protected void putLocalsBack(Event e) {
        if (CAN_MANAGE_LOCAL_VARS && this.localVars != null) {
            Variables.setLocalVariables((Event)e, (Object)this.localVars);
        }
    }

    protected boolean shouldContinue() {
        return this.getNext() != null;
    }

    protected void continueTrigger(Event e) {
        TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
    }

    protected void continueTriggerAndRemoveLocals(Event e) {
        this.continueTrigger(e);
        if (CAN_MANAGE_LOCAL_VARS) {
            Variables.removeLocals((Event)e);
        }
    }

    protected void putLocalsBackAndContinueTrigger(Event e) {
        if (CAN_MANAGE_LOCAL_VARS) {
            this.putLocalsBack(e);
        }
        this.continueTrigger(e);
    }
}

