/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.util.effects.AssertEffect;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

@Name(value="Assert True/False")
@Description(value={"Checks if a value is true/false. Fails if it is not."})
@Examples(value={"command checkTrue:\n\ttrigger:\n\t\tit \"should be true\":\n\t\t\tassert true if sender is console with message \"The console is the sender!\""})
@Since(value="1.0.0")
public class EffAssertTrueFalse
extends AssertEffect {
    private String value;
    private Expression<String> message;
    private Boolean isFalse;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.value = ((MatchResult)parseResult.regexes.get(0)).group();
        this.message = expr[0];
        this.isFalse = matchedPattern == 1;
        return true;
    }

    protected void execute(Event e) {
        if (this.isAvailable().booleanValue()) {
            String msg = this.message != null ? (String)this.message.getSingle(e) : "";
            Boolean finalValue = this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false") ? Boolean.parseBoolean(this.value) : Condition.parse((String)this.value, (String)("Can't understand this condition: " + this.value)).check(e);
            if (this.isFalse.booleanValue()) {
                if (msg.isEmpty()) {
                    this.latestTest.assertFalse(finalValue);
                } else {
                    this.latestTest.assertFalse(finalValue, msg);
                }
            } else if (msg.isEmpty()) {
                this.latestTest.assertTrue(finalValue);
            } else {
                this.latestTest.assertTrue(finalValue, msg);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "assert " + (this.isFalse != false ? "false" : "true") + " " + this.value + (this.message != null ? " with message " + this.message.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffAssertTrueFalse.class, (String[])new String[]{"assert [is] true [if] <.+> [with [[error] message] %-string%]", "assert [is] false [if] <.+> [with [[error] message] %-string%]"});
    }
}

