/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skester.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skester.util.effects.AssertEffect;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

@Name(value="Assert")
@Description(value={"Checks if condition is respected. Fails if it is not."})
@Examples(value={"command check:\n\ttrigger:\n\t\tit \"should be work\":\n\t\t\tassert if sender is console with message \"This sender is not the console!\""})
@Since(value="1.0.0")
public class EffAssert
extends AssertEffect {
    private String condition;
    private Expression<String> message;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.condition = ((MatchResult)parseResult.regexes.get(0)).group();
        this.message = expr[0];
        return true;
    }

    protected void execute(Event e) {
        if (this.isAvailable().booleanValue()) {
            String msg;
            String string = msg = this.message != null ? (String)this.message.getSingle(e) : "";
            if (msg.isEmpty()) {
                this.latestTest.assertTrue(Condition.parse((String)this.condition, (String)("Can't understand this condition: " + this.condition)).check(e));
            } else {
                this.latestTest.assertTrue(Condition.parse((String)this.condition, (String)("Can't understand this condition: " + this.condition)).check(e), msg);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "assert if " + this.condition + (this.message != null ? " with message " + this.message.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffAssert.class, (String[])new String[]{"assert [if] <.+>  [with [[error] message] %-string%]"});
    }
}

