/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicLong;

@Name(value="Size of File/Directory")
@Description(value={"Returns the size of a file or a directory in bytes."})
@Examples(value={"command size:\n\ttrigger:\n\t\tset {_size} to size of file path \"plugins/Skript/config.sk\"\n\t\tbroadcast \"The size of the config file is %{_extension}%\""})
@Since(value="1.7")
public class ExprSize
extends SimplePropertyExpression<Path, Number> {
    public Number convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                final AtomicLong size = new AtomicLong(0L);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    size.addAndGet(FileChannel.open(path, new OpenOption[0]).size());
                } else {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            size.addAndGet(attrs.size());
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                return size.intValue();
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return 0;
    }

    protected String getPropertyName() {
        return "size";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprSize.register(ExprSize.class, Number.class, (String)"(file|dir[ectory]) size", (String)"path");
    }
}

