/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="Last modified of File/Directory")
@Description(value={"Returns the date of the last modified date of a file or directory."})
@Examples(value={"command last modified:\n\ttrigger:\n\t\tset {_date} to last modified time of file path \"plugins/Skript\"\n\t\tbroadcast \"Oh, I recently coded in Skript: %{_date}%\""})
@Since(value="2.0")
public class ExprLastModified
extends SimplePropertyExpression<Path, Date> {
    public Date convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return new Date();
    }

    protected String getPropertyName() {
        return "last modified time";
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        ExprLastModified.register(ExprLastModified.class, Date.class, (String)"last modified (date|time)", (String)"path");
    }
}

