/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;

@Name(value="Last Access date of File/Directory")
@Description(value={"Returns the date of the last access of a file or directory."})
@Examples(value={"command last access:\n\ttrigger:\n\t\tset {_date} to last access time of file path \"passwords.txt\"\n\t\tbroadcast \"An hacker saw my file recently!: %{_date}%\""})
@Since(value="2.0")
public class ExprLastAccess
extends SimplePropertyExpression<Path, Date> {
    public Date convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                FileTime lastAccessTime = (FileTime)Files.getAttribute(path, "lastAccessTime", new LinkOption[0]);
                return new Date(lastAccessTime.toMillis());
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return new Date();
    }

    protected String getPropertyName() {
        return "last access time";
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        ExprLastAccess.register(ExprLastAccess.class, Date.class, (String)"last access (date|time)", (String)"path");
    }
}

