/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import org.bukkit.event.Event;

@Name(value="File/Directory")
@Description(value={"Returns a file or directory from its path. Can return a list of file."})
@Examples(value={"command create:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/test1.txt\" with \"hey\", \"just\", \"a\" and \"test\"\n\t\tremove \"hey\" from file path \"plugins/Skript/scripts/test1.txt\"\n\t\tadd \"with Skent\" to file path \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"Finished!\""})
@Since(value="1.0")
public class ExprFileDirectory
extends SimpleExpression<Path> {
    private Expression<String> paths;
    private boolean isSingle;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    protected Path[] get(Event e) {
        String[] pathsList;
        LinkedList<Path> finalPaths = new LinkedList<Path>();
        for (String path : pathsList = (String[])this.paths.getArray(e)) {
            finalPaths.add(Paths.get(path, new String[0]));
        }
        return finalPaths.toArray(new Path[finalPaths.size()]);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<? extends Path> getReturnType() {
        return Path.class;
    }

    public String toString(Event e, boolean debug) {
        return "file/directory " + this.paths.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprFileDirectory.class, Path.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (file[s]|dir[ector(y|ies)]) path %strings%"});
    }
}

