/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.olyno.skent.skript.events.bukkit.WatchingEvent;
import com.olyno.skent.util.WatchType;
import io.methvin.watcher.DirectoryWatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.Event;

@Name(value="On Watch File/Directory")
@Description(value={"When something changed in a path"})
@Examples(value={"watching file creation at \"plugins/Skript/scripts\":", "\tbroadcast \"I added a new script!\""})
@Since(value="2.1")
public class EvtWatching
extends SelfRegisteringSkriptEvent {
    private String[] paths;
    private WatchType type;
    private DirectoryWatcher watcher;
    private Trigger trigger;
    private WatchingEvent event;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.paths = (String[])args[0].getArray();
        if (matchedPattern < 3) {
            this.type = WatchType.values()[matchedPattern];
        }
        return true;
    }

    private void registerListener() {
        List allPaths = Arrays.asList(this.paths).stream().map(path -> Paths.get(path, new String[0])).collect(Collectors.toList());
        List<Path> directories = allPaths.stream().map(path -> Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent()).collect(Collectors.toList());
        try {
            this.watcher = DirectoryWatcher.builder().paths(directories).listener(event -> {
                if (allPaths.contains(event.path()) || allPaths.contains(event.path().getParent())) {
                    switch (event.eventType()) {
                        case CREATE: {
                            if (this.type != WatchType.CREATION && this.type != WatchType.ANY) break;
                            this.event.run(event.path());
                            break;
                        }
                        case MODIFY: {
                            if (this.type != WatchType.EDITION && this.type != WatchType.ANY) break;
                            this.event.run(event.path());
                            break;
                        }
                        case DELETE: {
                            if (this.type != WatchType.DELETION && this.type != WatchType.ANY) break;
                            this.event.run(event.path());
                        }
                    }
                }
            }).build();
            this.watcher.watchAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void register(Trigger trigger) {
        this.trigger = trigger;
        this.event = new WatchingEvent(trigger);
        this.registerListener();
    }

    public void unregister(Trigger t) {
        this.trigger = null;
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unregisterAll() {
    }

    public String toString(Event e, boolean debug) {
        return "watch for " + this.type.name().toLowerCase() + " for paths " + this.paths.toString();
    }

    static {
        Skript.registerEvent((String)"Watch Path", EvtWatching.class, WatchingEvent.class, (String[])new String[]{"[watch[ing] [for]] (file|dir[ectory]) creation[s] (at|for) [[the] (file[s]|dir[ector(y|ies)]|paths)] %strings%", "[watch[ing] [for]] (file|dir[ectory]) change[s] (at|for) [[the] (file[s]|dir[ector(y|ies)]|paths)] %strings%", "[watch[ing] [for]] (file|dir[ectory]) deletion[s] (at|for) [[the] (file[s]|dir[ector(y|ies)]|paths)] %strings%", "[watch[ing] [for]] (any|every) (file|dir[ectory]) change[s] (at|for) [[the] (file[s]|dir[ector(y|ies)]|paths)] %strings%"});
        EventValues.registerEventValue(WatchingEvent.class, Path.class, (Getter)new Getter<Path, WatchingEvent>(){

            public Path get(WatchingEvent e) {
                return e.getPath();
            }
        }, (int)0);
    }
}

