/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.ZipEvent;
import com.olyno.skent.util.AsyncEffect;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.bukkit.event.Event;

@Name(value="Zip File or Directory")
@Description(value={"Zips files and/or directories."})
@Examples(value={"command zip:\n\ttrigger:\n\t\tzip dir path \"plugins/Skript/scripts\" to dir path \"plugins/Skript/scripts.zip\"\n\t\tbroadcast \"Nice I did a backup!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand zip:\n\ttrigger:\n\t\tzip dir path \"plugins/Skript/scripts\" to dir path \"plugins/Skript/scripts.zip\":\n\t\t\tbroadcast \"Nice I did a backup!\""})
@Since(value="1.0")
public class EffZipFileDir
extends AsyncEffect {
    private Expression<Path> paths;
    private Expression<Path> target;
    private Expression<String> password;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.target = expr[1];
        if (matchedPattern == 0) {
            this.password = expr[2];
        }
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        String pass;
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        Path[] pathsList = pathArray;
        Path targetFile = (Path)this.target.getSingle(e);
        String string = pass = this.password != null ? (String)this.password.getSingle(e) : null;
        if (Pattern.compile("\\.zip$").matcher(targetFile.toString()).find()) {
            if (this.password != null && pass != null) {
                this.zip(pathsList, targetFile, pass);
            } else {
                this.zip(pathsList, targetFile, null);
            }
        }
    }

    private void zip(Path[] src, Path dest, String pass) {
        try {
            ZipFile zipFile = new ZipFile(dest.toString());
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(9);
            if (pass != null) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(0);
                parameters.setAesKeyStrength(1);
                parameters.setPassword(pass);
            }
            for (Path file : src) {
                if (!Files.exists(file, new LinkOption[0])) continue;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    zipFile.addFolder(file.toString(), parameters);
                    continue;
                }
                zipFile.addFile(file.toFile(), parameters);
            }
            new ZipEvent(src, dest, pass);
            new ChangeEvent(dest.getParent());
        }
        catch (ZipException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "zip " + this.paths.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        EffZipFileDir.registerAsyncEffect(EffZipFileDir.class, "zip %paths% to %path% with [password] %string%", "zip %paths% to %path%");
    }
}

