/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Insert Line")
@Description(value={"Inserts a line in a file."})
@Examples(value={"command insert:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/test1.txt\" with text \"Hey\", \"I'm\" and \"nice to meet you!\"\n\t\tinsert \"the creator\" at line 2 of file path \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"Of course I'm the creator!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand insert:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/test1.txt\" with text \"Hey\", \"I'm\" and \"nice to meet you!\":\n\t\t\tinsert \"the creator\" at line 2 of file path \"plugins/Skript/scripts/test1.txt\"\n\t\t\tbroadcast \"Of course I'm the creator!\""})
@Since(value="1.0")
public class EffInsertLine
extends AsyncEffect {
    private Expression<String> content;
    private Expression<Number> line;
    private Expression<Path> paths;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.content = expr[0];
        this.line = expr[1];
        this.paths = expr[2];
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        Path[] pathsList = pathArray;
        int theLine = ((Number)this.line.getSingle(e)).intValue();
        String currentContent = (String)this.content.getSingle(e);
        for (Path path : pathsList) {
            try {
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                if (lines.size() < theLine) {
                    for (int i = lines.size(); i < theLine; ++i) {
                        lines.add("");
                    }
                }
                lines.add(theLine - 1, currentContent);
                Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                new ChangeEvent(path);
            }
            catch (IOException ex) {
                if (!Files.exists(path, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
                    continue;
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "insert \"" + this.content.toString(e, debug) + "\" at line " + this.line.toString(e, debug) + " of " + this.paths.toString(e, debug);
    }

    static {
        EffInsertLine.registerAsyncEffect(EffInsertLine.class, "insert %strings% at line %number% of %path%");
    }
}

