/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ExecuteEvent;
import com.olyno.skent.util.AsyncEffect;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.bukkit.event.Event;

@Name(value="Run/Execute File")
@Description(value={"Runs/Executes a file."})
@Examples(value={"command execute:\n\ttrigger:\n\t\texecute file path \"plugins/myAwesomeBat.bat\"\n\t\tbroadcast \"File executed! I'm now a hacker!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand execute:\n\ttrigger:\n\t\texecute file path \"plugins/myAwesomeBat.bat\":\n\t\t\tbroadcast \"File executed! I'm now a hacker!\""})
@Since(value="1.0")
public class EffExecuteFile
extends AsyncEffect {
    private Expression<Path> paths;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathsList;
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        for (Path path : pathsList = pathArray) {
            if (!Files.exists(path, new LinkOption[0]) || !Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) continue;
            try {
                Desktop.getDesktop().open(path.toFile());
                new ExecuteEvent(path);
            }
            catch (IOException ex) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "execute " + this.paths.toString(e, debug);
    }

    static {
        EffExecuteFile.registerAsyncEffect(EffExecuteFile.class, "(execute|run) %paths%");
    }
}

