/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.CopyEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.event.Event;

@Name(value="Copy File or directory")
@Description(value={"Copy a file or a directory to another."})
@Examples(value={"# /!\\ if the copied file already exist, it will be replaced /!\\ \n\ncommand copy:\n\ttrigger:\n\t\tcopy file path \"plugins/Skript/scrips/MyAwesomeScript.sk\" to file path \"plugins/Skript/scrips/MyAwesomeScriptCopy.sk\"\n\t\tbroadcast \"Copied!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand copy:\n\ttrigger:\n\t\tcopy file path \"plugins/Skript/scrips/MyAwesomeScript.sk\" to file path \"plugins/Skript/scrips/MyAwesomeScriptCopy.sk\":\n\t\t\tbroadcast \"Copied!\""})
@Since(value="1.0")
public class EffCopyFileDir
extends AsyncEffect {
    private Expression<Path> sources;
    private Expression<Path> target;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sources = expr[0];
        this.target = expr[1];
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] sourceFiles = (Path[])this.sources.getArray(e);
        Path targetFile = (Path)this.target.getSingle(e);
        try {
            for (Path sourceFile : sourceFiles) {
                if (Files.exists(sourceFile, new LinkOption[0])) {
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        this.copyDir(sourceFile, targetFile);
                    } else {
                        if (Files.isDirectory(targetFile, new LinkOption[0])) {
                            targetFile = Paths.get(targetFile.toAbsolutePath() + File.separator + sourceFile.getFileName(), new String[0]);
                        }
                        Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    throw new IOException();
                }
                new ChangeEvent(targetFile);
                new CopyEvent(sourceFile, targetFile);
            }
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    private void copyDir(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public String toString(Event e, boolean debug) {
        return "copy " + this.sources.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        EffCopyFileDir.registerAsyncEffect(EffCopyFileDir.class, "copy %paths% to %path%");
    }
}

