/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PropertyPathCondition;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;

@Name(value="File is System?")
@Description(value={"Checks if the file is a system or not."})
@Examples(value={"command system:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeGame.exe\" is system file:\n\t\t\tbroadcast \"Oh, probably the bios!\""})
@Since(value="2.0")
public class CondFileIsSystem
extends PropertyPathCondition<Path> {
    public boolean check(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                DosFileAttributes attributes = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
                return attributes.isSystem();
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return false;
    }

    protected String getPropertyName() {
        return "system";
    }

    static {
        CondFileIsSystem.registerCondition(CondFileIsSystem.class, "system", "path");
    }
}

