/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PropertyPathCondition;
import java.nio.file.Files;
import java.nio.file.Path;

@Name(value="File is executable?")
@Description(value={"Checks if the file is executable or not."})
@Examples(value={"command executable:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeGame.exe\" is executable file:\n\t\t\tbroadcast \"Oh, probably a game!\""})
@Since(value="1.0")
public class CondFileIsExecutable
extends PropertyPathCondition<Path> {
    public boolean check(Path path) {
        return Files.isExecutable(path);
    }

    protected String getPropertyName() {
        return "executable";
    }

    static {
        CondFileIsExecutable.registerCondition(CondFileIsExecutable.class, "exe[cutable]", "path");
    }
}

