/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.util;

import ch.njol.util.coll.iterator.EnumerationIterable;
import com.olyno.skent.Skent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PackageFilter<T> {
    File file;
    Skent plugin = Skent.instance;
    String basePackage;
    String[] subPackages;
    List<Class<T>> classes = new LinkedList<Class<T>>();

    public PackageFilter(String basePackage, String ... subPackages) {
        this.basePackage = basePackage;
        this.subPackages = subPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<T>> getClasses() throws IOException {
        this.classes.clear();
        JarFile jar = new JarFile(this.getPath());
        for (int i = 0; i < this.subPackages.length; ++i) {
            this.subPackages[i] = this.subPackages[i].replace('.', '/') + "/";
        }
        this.basePackage = this.basePackage.replace('.', '/') + "/";
        try {
            for (JarEntry e : new EnumerationIterable(jar.entries())) {
                if (!e.getName().startsWith(this.basePackage) || !e.getName().endsWith(".class")) continue;
                boolean load = this.subPackages.length == 0;
                for (String sub : this.subPackages) {
                    if (!e.getName().startsWith(sub, this.basePackage.length())) continue;
                    load = true;
                    break;
                }
                if (!load) continue;
                String c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                try {
                    this.classes.add(Class.forName(c, true, ((Object)((Object)this.plugin)).getClass().getClassLoader()));
                }
                catch (ClassNotFoundException | ExceptionInInitializerError ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return this.classes;
    }

    public File getPath() {
        if (this.file != null) {
            return this.file;
        }
        try {
            Method getFile = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFile.setAccessible(true);
            this.file = (File)getFile.invoke((Object)this.plugin, new Object[0]);
            return this.file;
        }
        catch (IllegalArgumentException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            assert (false);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return null;
    }
}

