/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="Usable Space")
@Description(value={"Returns the usable space of a directory in bytes."})
@Examples(value={"command space:\n\ttrigger:\n\t\tset {_space} to usable space of directory path \"plugins/Skript\"\n\t\tbroadcast \"Wow I should work more on my script, I have enought space available: %{_space}%\""})
@Since(value="2.0")
public class ExprUsableSpace
extends SimplePropertyExpression<Path, Number> {
    public Number convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                FileStore store = Files.getFileStore(path);
                return store.getUsableSpace();
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return 0;
    }

    protected String getPropertyName() {
        return "usable space";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprUsableSpace.register(ExprUsableSpace.class, Number.class, (String)"usable space", (String)"path");
    }
}

