/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;

@Name(value="Creation date of File/Directory")
@Description(value={"Returns the date of the creation of a file or directory."})
@Examples(value={"command created at:\n\ttrigger:\n\t\tset {_date} to creation time of file path \"plugins/Skript/scripts/MyAwesomeScript.sk\"\n\t\tbroadcast \"Oh, I recently created this script, awesome!: %{_date}%\""})
@Since(value="2.0")
public class ExprCreatedAt
extends SimplePropertyExpression<Path, Date> {
    public Date convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                FileTime creationTime = (FileTime)Files.getAttribute(path, "creationTime", new LinkOption[0]);
                return new Date(creationTime.toMillis());
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return new Date();
    }

    protected String getPropertyName() {
        return "creation time";
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        ExprCreatedAt.register(ExprCreatedAt.class, Date.class, (String)"creat(ed|ion) (date|time)", (String)"path");
    }
}

